/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.view.main;

import java.awt.Dimension;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.utils.Utils;
import kz.akkamal.tinysigner.view.main.AbstractView;

public class ViewWithSignInfoBlock
extends AbstractView {
    private JPanel viewSignaturesPanel;
    private JButton viewSignaturesiBtn;
    private JLabel signaturesLabel;

    public ViewWithSignInfoBlock(Controller controller) throws Exception {
        super(controller);
    }

    @Override
    protected void prepareVariables() {
        super.prepareVariables();
        this.viewSignaturesPanel = new JPanel();
        this.viewSignaturesiBtn = new JButton();
        this.signaturesLabel = new JLabel();
        this.viewSignaturesiBtn.setIcon(new ImageIcon(AbstractView.class.getResource("/icons8-eye-18.png")));
        this.viewSignaturesiBtn.setToolTipText(Utils.getI18nMessage("view.show.signatures"));
        this.viewSignaturesiBtn.setMaximumSize(new Dimension(133, 23));
        this.viewSignaturesiBtn.setMinimumSize(new Dimension(133, 23));
        this.signaturesLabel.setText(Utils.getI18nMessage("view.signers.in.file") + " ");
    }

    @Override
    protected void prepareListeners() {
        super.prepareListeners();
        this.viewSignaturesiBtn.addActionListener(actionEvent -> this.controller.showSignersInfo());
    }

    @Override
    protected void prepareLayouts() {
        GroupLayout openFilePanelLayout = new GroupLayout(this.openFilePanel);
        this.openFilePanel.setLayout(openFilePanelLayout);
        openFilePanelLayout.setHorizontalGroup(openFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, openFilePanelLayout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addComponent(this.openFileBtn, -2, -1, -2)));
        openFilePanelLayout.setVerticalGroup(openFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(openFilePanelLayout.createSequentialGroup().addComponent(this.openFileBtn, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout downLoadFilePanelLayout = new GroupLayout(this.downLoadFilePanel);
        this.downLoadFilePanel.setLayout(downLoadFilePanelLayout);
        downLoadFilePanelLayout.setHorizontalGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downLoadFilePanelLayout.createSequentialGroup().addContainerGap().addGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.downloadedLabel, -1, 48, Short.MAX_VALUE).addComponent(this.fileNameLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.downloadedTextLabel, -1, -1, Short.MAX_VALUE).addComponent(this.fileNameTextLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.openFilePanel, -2, -1, -2).addContainerGap()));
        downLoadFilePanelLayout.setVerticalGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(downLoadFilePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openFilePanel, -2, -1, -2).addGroup(downLoadFilePanelLayout.createSequentialGroup().addGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameTextLabel).addComponent(this.fileNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(downLoadFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadedLabel).addComponent(this.downloadedTextLabel))))));
        GroupLayout signFilePanelLayout = new GroupLayout(this.signFilePanel);
        this.signFilePanel.setLayout(signFilePanelLayout);
        signFilePanelLayout.setHorizontalGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(signFilePanelLayout.createSequentialGroup().addContainerGap().addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyChooseComboBox, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, signFilePanelLayout.createSequentialGroup().addComponent(this.keyStoragePassword).addGap(18, 18, 18).addComponent(this.openBtn, -2, 133, -2)).addGroup(signFilePanelLayout.createSequentialGroup().addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.keyOwnerLabel, -1, -1, Short.MAX_VALUE).addComponent(this.keyValidDateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyOwnerTextLabel, -1, 385, Short.MAX_VALUE).addComponent(this.keyValidDateTextLabel, -1, -1, Short.MAX_VALUE))).addGroup(signFilePanelLayout.createSequentialGroup().addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chooseContainerLabel).addComponent(this.keyStoragePasswordLabel).addComponent(this.keyChooseLabel).addComponent(this.keyPathLabel)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, signFilePanelLayout.createSequentialGroup().addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.containerComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.selectContainer)).addGap(18, 18, 18).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectKeyButton, GroupLayout.Alignment.TRAILING).addComponent(this.loadStorageButton, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        signFilePanelLayout.setVerticalGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(signFilePanelLayout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.chooseContainerLabel).addGap(6, 6, 6).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loadStorageButton, -2, 24, -2).addComponent(this.containerComboBox, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keyPathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectContainer, -2, 24, -2).addComponent(this.selectKeyButton, -2, 24, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keyStoragePasswordLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openBtn, GroupLayout.Alignment.TRAILING).addComponent(this.keyStoragePassword, GroupLayout.Alignment.TRAILING, -2, 25, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keyChooseLabel).addGap(5, 5, 5).addComponent(this.keyChooseComboBox, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyOwnerLabel, -2, 14, -2).addComponent(this.keyOwnerTextLabel, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(signFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyValidDateLabel).addComponent(this.keyValidDateTextLabel)).addGap(6, 6, 6)));
        GroupLayout viewSignaturesPanelLayout = new GroupLayout(this.viewSignaturesPanel);
        this.viewSignaturesPanel.setLayout(viewSignaturesPanelLayout);
        viewSignaturesPanelLayout.setHorizontalGroup(viewSignaturesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, viewSignaturesPanelLayout.createSequentialGroup().addGap(0, 20, Short.MAX_VALUE).addComponent(this.viewSignaturesiBtn, -2, -1, -2)));
        viewSignaturesPanelLayout.setVerticalGroup(viewSignaturesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewSignaturesiBtn, -2, -1, -2));
        GroupLayout signaturesPanelLayout = new GroupLayout(this.signaturesPanel);
        this.signaturesPanel.setLayout(signaturesPanelLayout);
        signaturesPanelLayout.setHorizontalGroup(signaturesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signaturesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.signaturesLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.viewSignaturesPanel, -2, -1, -2).addContainerGap()));
        signaturesPanelLayout.setVerticalGroup(signaturesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signaturesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(signaturesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.viewSignaturesPanel, -2, -1, -2).addComponent(this.signaturesLabel)).addGap(82, 82, 82)));
        GroupLayout productInfoPanelLayout = new GroupLayout(this.productInfoPanel);
        this.productInfoPanel.setLayout(productInfoPanelLayout);
        productInfoPanelLayout.setHorizontalGroup(productInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(productInfoPanelLayout.createSequentialGroup().addComponent(this.productLogoLabel, -2, 240, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 52, Short.MAX_VALUE).addComponent(this.productVersionLabel, -2, 218, -2).addContainerGap()));
        productInfoPanelLayout.setVerticalGroup(productInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.productLogoLabel, -1, -1, Short.MAX_VALUE).addGroup(productInfoPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.productVersionLabel).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signFilePanel, -1, -1, Short.MAX_VALUE).addComponent(this.signaturesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.downLoadFilePanel, -1, -1, Short.MAX_VALUE).addComponent(this.productInfoPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.copyrightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.signBtn, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelBtn, -2, 126, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.productInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downLoadFilePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.signaturesPanel, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signFilePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelBtn, -1, -1, Short.MAX_VALUE).addComponent(this.signBtn).addComponent(this.copyrightLabel)).addContainerGap()));
    }

    @Override
    public void changeViewEnableState(boolean state) {
        super.changeViewEnableState(state);
        this.viewSignaturesiBtn.setEnabled(state);
    }

    @Override
    public void updateFileInfo() {
        super.updateFileInfo();
        if (this.fileDownloaded) {
            boolean containSigners = false;
            String signaturesLabelText = "";
            if (this.controller.getModel().getSignVerResults() != null) {
                int signersAmount = this.controller.getModel().getSignVerResults().size();
                if (signersAmount == 0) {
                    this.viewSignaturesiBtn.setEnabled(false);
                } else if (signersAmount == 1) {
                    signaturesLabelText = this.controller.getModel().getSignVerResults().get(0).getName();
                    containSigners = true;
                    this.viewSignaturesiBtn.setEnabled(true);
                } else {
                    signaturesLabelText = this.controller.getModel().getSignVerResults().get(0).getName();
                    signaturesLabelText = signaturesLabelText + " " + String.format(Utils.getI18nMessage("view.and.label"), signersAmount - 1);
                    containSigners = true;
                    this.viewSignaturesiBtn.setEnabled(true);
                }
            } else {
                this.viewSignaturesiBtn.setEnabled(false);
            }
            if (signaturesLabelText.length() >= 40) {
                signaturesLabelText = signaturesLabelText.substring(0, 40) + "...";
            }
            if (containSigners) {
                ImageIcon imageIcon = this.controller.getModel().isSignaturesInvalid() ? new ImageIcon(AbstractView.class.getResource("/error.png")) : new ImageIcon(AbstractView.class.getResource("/ok2.png"));
                this.signaturesLabel.setIcon(imageIcon);
                this.signaturesLabel.setText(this.signaturesLabel.getText() + signaturesLabelText);
            } else {
                this.signaturesLabel.setText(Utils.getI18nMessage("view.signers.absent"));
            }
        }
    }
}

