/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.view.main;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.entities.KeyStorageInfo;
import kz.akkamal.tinysigner.exception.ClientException;
import kz.akkamal.tinysigner.utils.Utils;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.reference.KeyStoreEntry;

public abstract class AbstractView
extends JFrame {
    protected JComboBox<String> containerComboBox;
    protected JComboBox<String> keyChooseComboBox;
    protected JComboBox<String> selectContainer;
    protected JPasswordField keyStoragePassword;
    protected JLabel keyStoragePasswordLabel;
    protected JLabel keyValidDateLabel;
    protected JLabel keyValidDateTextLabel;
    protected JLabel keyPathLabel;
    protected JLabel keyChooseLabel;
    protected JLabel keyOwnerLabel;
    protected JLabel keyOwnerTextLabel;
    protected JLabel copyrightLabel;
    protected JLabel downloadedLabel;
    protected JLabel downloadedTextLabel;
    protected JLabel fileNameLabel;
    protected JLabel fileNameTextLabel;
    protected JLabel chooseContainerLabel;
    protected JLabel productLogoLabel;
    protected JLabel productVersionLabel;
    protected JButton loadStorageButton;
    protected JButton cancelBtn;
    protected JButton openBtn;
    protected JButton openFileBtn;
    protected JButton selectKeyButton;
    protected JButton signBtn;
    protected JPanel downLoadFilePanel;
    protected JPanel openFilePanel;
    protected JPanel productInfoPanel;
    protected JPanel signaturesPanel;
    protected JPanel signFilePanel;
    protected Controller controller;
    private boolean canceledByUser;
    private boolean keySelected;
    protected String selectedAlias;
    protected boolean fileDownloaded;
    private String LAST_USED_FOLDER;

    public AbstractView(Controller controller) throws Exception {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() throws Exception {
        this.prepareVariables();
        this.prepareLayouts();
        this.prepareListeners();
        this.setTitle("TinySign");
        this.setCursor(new Cursor(0));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.changeViewEnableState(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.upModuleWindow();
    }

    protected void prepareListeners() {
        this.selectKeyButton.addActionListener(actionEvent -> {
            FileNameExtensionFilter filter = new FileNameExtensionFilter(Utils.getI18nMessage("view.pkcs12.filter.label"), "pfx", "p12", "jks");
            JFileChooser jfc = this.LAST_USED_FOLDER == null ? new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory()) : new JFileChooser(this.LAST_USED_FOLDER);
            jfc.setDialogTitle(Utils.getI18nMessage("view.key.choose.label"));
            jfc.setFileFilter(filter);
            int returnValue = jfc.showOpenDialog(this);
            if (returnValue == 0) {
                File selectedFile = jfc.getSelectedFile();
                this.selectContainer.removeAllItems();
                this.selectContainer.addItem(selectedFile.getPath());
                this.selectContainer.setEnabled(false);
                this.LAST_USED_FOLDER = jfc.getCurrentDirectory().getAbsolutePath();
                this.keyStoragePassword.requestFocusInWindow();
                this.clearBottomPanel();
                this.signBtn.setEnabled(false);
                this.keySelected = false;
            }
        });
        this.containerComboBox.addItemListener(actionEvent -> {
            if (actionEvent.getStateChange() == 1) {
                String selectedContainerType = (String)actionEvent.getItem();
                KeyStorageInfo keyStorageInfo = new KeyStorageInfo(selectedContainerType);
                this.controller.getModel().setKeyStorageInfo(keyStorageInfo);
                this.changeSelectStorageInfo();
                this.clearBottomPanel();
                this.signBtn.setEnabled(false);
                this.keySelected = false;
            }
        });
        this.cancelBtn.addActionListener(actionEvent -> this.disposeView(true));
        this.openFileBtn.addActionListener(actionEvent -> {
            try {
                Desktop.getDesktop().open(new File(this.controller.getModel().getSaveToPath()));
            }
            catch (IOException e) {
                this.showErrorMessage(Utils.getI18nMessage("file.open.error") + " " + this.controller.getModel().getSaveToPath());
            }
        });
        this.loadStorageButton.addActionListener(actionEvent -> this.controller.updateContainersList());
        this.openBtn.addActionListener(actionEvent -> {
            try {
                this.signBtn.setEnabled(false);
                this.openBtn.setEnabled(false);
                this.controller.getModel().clearStorageInfo();
                String path = (String)this.selectContainer.getSelectedItem();
                char[] password = this.keyStoragePassword.getPassword();
                if (path == null || path.isEmpty() || password == null || password.length == 0) {
                    this.showErrorMessage(Utils.getI18nMessage("view.storage.or.pass.not.set"));
                    return;
                }
                this.controller.getModel().getKeyStorageInfo().setContainer(path);
                this.controller.getModel().getKeyStorageInfo().setPassword(new String(password));
                SwingUtilities.invokeLater(() -> {
                    try {
                        this.controller.loadKeys();
                    }
                    catch (ClientException e) {
                        BundleLog.LOG.error(e.getMessage(), e);
                        this.showErrorMessage(e.getMessage());
                        this.signBtn.setEnabled(false);
                        this.keyChooseComboBox.removeAllItems();
                        this.clearBottomPanel();
                        return;
                    }
                    this.keySelected = true;
                    if (this.controller.getModel().getKeyStorageInfo().getStorage() == Storage.PKCS12) {
                        this.controller.getModel().setLastSuccessP12KeyDirectory(this.LAST_USED_FOLDER);
                        this.controller.getModel().setLastSuccessP12KeyFullPath(path);
                    }
                    this.prepareBottomPanel();
                    if (this.fileDownloaded && !this.controller.getModel().isSignaturesInvalid()) {
                        this.signBtn.setEnabled(true);
                    }
                    this.openBtn.setEnabled(true);
                });
            }
            catch (Exception e) {
                BundleLog.LOG.error(e.getMessage(), e);
                this.signBtn.setEnabled(false);
                this.showErrorMessage(Utils.getI18nMessage("unknown.error"));
                this.clearBottomPanel();
            }
            this.openBtn.setEnabled(true);
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (AbstractView.this.canceledByUser) {
                    AbstractView.this.controller.bindProcessResult(ErrorCode.USER_CANCELED.getErrorCode(), "module was closed");
                }
                AbstractView.this.controller.releaseLock();
            }
        });
        this.keyStoragePassword.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeButtonStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeButtonStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeButtonStatus();
            }

            private void changeButtonStatus() {
                AbstractView.this.openBtn.setEnabled(AbstractView.this.keyStoragePassword.getPassword().length != 0);
            }
        });
        this.keyChooseComboBox.addItemListener(actionEvent -> {
            if (actionEvent.getStateChange() == 1) {
                String selectedKey = (String)actionEvent.getItem();
                Pattern pattern = Pattern.compile("<(.+?)>", 32);
                Matcher matcher = pattern.matcher(selectedKey);
                if (matcher.find()) {
                    this.selectedAlias = matcher.group(1);
                    this.prepareCertInfo();
                } else {
                    this.showErrorMessage(Utils.getI18nMessage("unknown.error"));
                }
            }
        });
        this.signBtn.addActionListener(actionEvent -> {
            this.controller.getModel().getKeyStorageInfo().setAlias(this.selectedAlias);
            this.controller.signFile();
        });
    }

    protected void prepareVariables() {
        this.canceledByUser = true;
        this.loadStorageButton = new JButton();
        this.downLoadFilePanel = new JPanel();
        this.fileNameLabel = new JLabel();
        this.downloadedLabel = new JLabel();
        this.fileNameTextLabel = new JLabel();
        this.downloadedTextLabel = new JLabel();
        this.openFilePanel = new JPanel();
        this.openFileBtn = new JButton();
        this.signFilePanel = new JPanel();
        this.chooseContainerLabel = new JLabel();
        this.containerComboBox = new JComboBox();
        this.selectContainer = new JComboBox();
        this.keyStoragePasswordLabel = new JLabel();
        this.keyStoragePassword = new JPasswordField();
        this.openBtn = this.createButtonWithKeyListener(10);
        this.keyPathLabel = new JLabel();
        this.keyChooseComboBox = new JComboBox();
        this.keyOwnerLabel = new JLabel();
        this.keyValidDateLabel = new JLabel();
        this.keyChooseLabel = new JLabel();
        this.keyOwnerTextLabel = new JLabel();
        this.keyValidDateTextLabel = new JLabel();
        this.selectKeyButton = new JButton();
        this.cancelBtn = new JButton();
        this.signBtn = new JButton();
        this.signaturesPanel = new JPanel();
        this.productInfoPanel = new JPanel();
        this.productLogoLabel = new JLabel();
        this.productVersionLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.fileNameLabel.setText(Utils.getI18nMessage("view.file.name.label") + " ");
        this.downloadedLabel.setText(Utils.getI18nMessage("view.file.size.label") + " ");
        this.downloadedTextLabel.setText(Utils.getI18nMessage("view.server.connection.establishing"));
        this.keyPathLabel.setText(Utils.getI18nMessage("view.key.storage.path.label"));
        this.keyOwnerLabel.setText(Utils.getI18nMessage("view.key.owner.label"));
        this.keyValidDateLabel.setText(Utils.getI18nMessage("view.valid.to.label"));
        this.keyChooseLabel.setLabelFor(this.keyChooseComboBox);
        this.keyChooseLabel.setText(Utils.getI18nMessage("view.key.for.sign.label"));
        this.fileNameTextLabel.setFont(new Font("Tahoma", 1, 11));
        this.keyOwnerTextLabel.setFont(new Font("Tahoma", 1, 11));
        this.keyValidDateTextLabel.setFont(new Font("Tahoma", 1, 11));
        this.downLoadFilePanel.setBorder(BorderFactory.createTitledBorder(null, Utils.getI18nMessage("view.file.to.sign.label"), 0, 0, new Font("Dialog", 1, 12)));
        this.setIconImage(new ImageIcon(AbstractView.class.getResource("/ts_small_logo_16px.png")).getImage());
        this.openFileBtn.setIcon(new ImageIcon(AbstractView.class.getResource("/icons8-eye-18.png")));
        this.openFileBtn.setMaximumSize(new Dimension(133, 23));
        this.openFileBtn.setMinimumSize(new Dimension(133, 23));
        this.selectContainer.setEnabled(true);
        this.selectContainer.setEditable(false);
        this.selectContainer.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
        this.openBtn.setEnabled(false);
        this.openBtn.setText(Utils.getI18nMessage("view.open"));
        this.signFilePanel.setBorder(BorderFactory.createTitledBorder(null, Utils.getI18nMessage("view.sign.key.label"), 0, 0, new Font("Dialog", 1, 12)));
        this.chooseContainerLabel.setDisplayedMnemonic('\u0412');
        this.chooseContainerLabel.setLabelFor(this.containerComboBox);
        this.chooseContainerLabel.setText(Utils.getI18nMessage("view.key.storage.label"));
        this.chooseContainerLabel.setToolTipText("");
        this.containerComboBox.setEditable(false);
        this.containerComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{Utils.getI18nMessage("view.pkcs12.label")}));
        this.keyStoragePasswordLabel.setText(Utils.getI18nMessage("view.password"));
        this.loadStorageButton.setIcon(new ImageIcon(AbstractView.class.getResource("/icons8-refresh-18.png")));
        this.loadStorageButton.setToolTipText(Utils.getI18nMessage("view.update.list.label"));
        this.selectKeyButton.setIcon(new ImageIcon(AbstractView.class.getResource("/icons8-file-configuration-18.png")));
        this.keyChooseComboBox.setEnabled(false);
        this.cancelBtn.setText(Utils.getI18nMessage("view.cancel.label"));
        this.signBtn.setText(Utils.getI18nMessage("view.sign.label"));
        this.signBtn.setEnabled(false);
        this.signaturesPanel.setBorder(BorderFactory.createTitledBorder(null, Utils.getI18nMessage("view.signatures.in.file"), 0, 0, new Font("Dialog", 1, 12)));
        this.productInfoPanel.setBackground(new Color(255, 255, 255));
        this.productLogoLabel.setIcon(new ImageIcon(AbstractView.class.getResource("/tinysignLogo.png")));
        this.productVersionLabel.setHorizontalAlignment(4);
        String appVers = null;
        try {
            appVers = Utils.readAppVers();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.productVersionLabel.setText(Utils.getI18nMessage("view.app.version.label") + " " + appVers);
        this.copyrightLabel.setForeground(new Color(102, 102, 102));
        this.copyrightLabel.setText("\u00a9 2021, Ak Kamal Security");
    }

    protected abstract void prepareLayouts();

    public void upModuleWindow() {
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    private void prepareCertInfo() {
        KeyStorageInfo keyStorageInfo = this.controller.getModel().getKeyStorageInfo();
        KeyStoreEntry keyStoreEntry = keyStorageInfo.getAvailableKeys().get(this.selectedAlias);
        String subjectCn = keyStoreEntry.getSubjectCn();
        Date notAfter = keyStoreEntry.getX509Certificate().getNotAfter();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy(HH:mm)");
        String to = simpleDateFormat.format(notAfter);
        this.keyOwnerTextLabel.setText(subjectCn);
        if (new Date().after(notAfter)) {
            this.keyValidDateTextLabel.setForeground(Color.RED);
        } else {
            this.keyValidDateTextLabel.setForeground(Color.BLACK);
        }
        this.keyValidDateTextLabel.setText(to);
    }

    private void prepareBottomPanel() {
        this.keyChooseComboBox.removeAllItems();
        KeyStorageInfo keyStorageInfo = this.controller.getModel().getKeyStorageInfo();
        if (keyStorageInfo.getAvailableKeys().size() > 1) {
            this.keyChooseComboBox.setEnabled(true);
            for (Map.Entry<String, KeyStoreEntry> pair : keyStorageInfo.getAvailableKeys().entrySet()) {
                String alias = pair.getKey();
                String certInfo = pair.getValue().getAlgorithm() + " | " + pair.getValue().getSerialNumber();
                this.keyChooseComboBox.addItem("<" + alias + "> " + certInfo);
            }
        } else {
            this.keyChooseComboBox.setEnabled(false);
            Map.Entry<String, KeyStoreEntry> pair = this.controller.getModel().getKeyStorageInfo().getAvailableKeys().entrySet().iterator().next();
            String alias = pair.getKey();
            String certInfo = pair.getValue().getAlgorithm() + " | " + pair.getValue().getSerialNumber();
            this.keyChooseComboBox.addItem("<" + alias + "> " + certInfo);
        }
    }

    private void clearBottomPanel() {
        this.keyChooseComboBox.removeAllItems();
        this.keyChooseComboBox.setEnabled(false);
        this.keyOwnerTextLabel.setText("");
        this.keyValidDateTextLabel.setText("");
    }

    private void changeSelectStorageInfo() {
        this.selectContainer.removeAllItems();
        if (this.controller.getModel().getKeyStorageInfo().getStorage() != Storage.PKCS12) {
            this.selectKeyButton.setEnabled(false);
            if (this.fileDownloaded) {
                this.selectContainer.setEnabled(true);
            }
            this.keyPathLabel.setText("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430: " + this.controller.getModel().getKeyStorageInfo().getStorage());
            List<String> containers = this.controller.getModel().getKeyStorageInfo().getContainers();
            for (String container : containers) {
                this.selectContainer.addItem(container);
            }
        } else {
            String fullPath;
            String lastSuccessP12KeyDirectory;
            this.controller.loadLastSuccessKeyStorePath();
            this.keyPathLabel.setText(Utils.getI18nMessage("view.key.storage.path.label"));
            this.selectContainer.setEnabled(false);
            this.selectContainer.setEditable(false);
            if (this.fileDownloaded) {
                this.selectKeyButton.setEnabled(true);
            }
            if ((lastSuccessP12KeyDirectory = this.controller.getModel().getLastSuccessP12KeyDirectory()) != null && !lastSuccessP12KeyDirectory.trim().isEmpty()) {
                this.LAST_USED_FOLDER = lastSuccessP12KeyDirectory;
            }
            if ((fullPath = this.controller.getModel().getLastSuccessP12KeyFullPath()) != null && !fullPath.trim().isEmpty()) {
                this.selectContainer.addItem(fullPath);
                this.keyStoragePassword.requestFocusInWindow();
            }
        }
    }

    public void showMessage(boolean error) {
        String message = this.controller.getModel().getMessage();
        if (error) {
            this.showErrorMessage(message);
        } else {
            this.showInformationMessage(message);
        }
    }

    private void showErrorMessage(String errorMessage) {
        JOptionPane optionPane = new JOptionPane(errorMessage, 0);
        JDialog dialog = optionPane.createDialog(this, Utils.getI18nMessage("view.error.label"));
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
    }

    private void showInformationMessage(String infoMessage) {
        JOptionPane optionPane = new JOptionPane(infoMessage, 1);
        JDialog dialog = optionPane.createDialog(this, Utils.getI18nMessage("view.notify.label"));
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
    }

    public void disposeView(boolean canceledByUser) {
        this.canceledByUser = canceledByUser;
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void updateContainersList() {
        this.containerComboBox.removeAllItems();
        List<String> availableTokens = this.controller.getModel().getAvailableTokens();
        for (String availableToken : availableTokens) {
            this.containerComboBox.addItem(availableToken);
        }
    }

    public void enableContainerListBox() {
        this.containerComboBox.setEnabled(true);
    }

    public void changeViewEnableState(boolean state) {
        this.openFileBtn.setEnabled(state);
        if (state && this.keySelected && !this.controller.getModel().isSignaturesInvalid()) {
            this.signBtn.setEnabled(true);
        }
    }

    public void blockFullViewExcludeCancelBtn() {
        this.changeViewEnableState(false);
        this.loadStorageButton.setEnabled(false);
        this.openBtn.setEnabled(false);
        this.signBtn.setEnabled(false);
        this.containerComboBox.setEnabled(false);
        this.selectKeyButton.setEnabled(false);
        this.keyStoragePassword.setEnabled(false);
        this.keyChooseComboBox.setEnabled(false);
    }

    public void unblockFullView() {
        this.changeViewEnableState(true);
        this.loadStorageButton.setEnabled(true);
        this.openBtn.setEnabled(true);
        this.signBtn.setEnabled(true);
        this.containerComboBox.setEnabled(true);
        this.selectKeyButton.setEnabled(true);
        this.keyStoragePassword.setEnabled(true);
    }

    public void setFileDownloaded(boolean fileDownloaded) {
        this.fileDownloaded = fileDownloaded;
    }

    private JButton createButtonWithKeyListener(int key) {
        JButton btn = new JButton();
        InputMap im = btn.getInputMap(2);
        ActionMap am = btn.getActionMap();
        im.put(KeyStroke.getKeyStroke(key, 0), "process");
        am.put("process", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton btn = (JButton)e.getSource();
                btn.doClick();
            }
        });
        return btn;
    }

    public void updateFileInfo() {
        if (this.fileNameTextLabel.getText().trim().isEmpty()) {
            if (this.controller.getModel().getFileName().length() > 45) {
                this.fileNameTextLabel.setText(this.controller.getModel().getFileName().substring(0, 45) + "...");
            } else {
                this.fileNameTextLabel.setText(this.controller.getModel().getFileName());
            }
        }
        if (this.fileDownloaded) {
            this.downloadedTextLabel.setText(String.format(Utils.getI18nMessage("view.download.complete.info.label"), Utils.convertBytesToKb(this.controller.getModel().getDownloaded())));
        } else {
            String pattern = this.controller.getModel().getTotalSize() == -1 || this.controller.getModel().getTotalSize() == 0 ? Utils.getI18nMessage("view.downloading.info.label") : Utils.getI18nMessage("view.downloading.info.label2");
            this.downloadedTextLabel.setText(String.format(pattern, Utils.convertBytesToKb(this.controller.getModel().getDownloaded()), this.controller.getModel().getTotalSize() == -1 ? "" : Double.valueOf(Utils.convertBytesToKb(this.controller.getModel().getTotalSize()))));
        }
    }

    public void informAboutVerifyingProcess() {
        this.downloadedTextLabel.setText(Utils.getI18nMessage("view.signatures.verifying.process"));
    }
}

