/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.view;

import java.awt.Font;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.entities.AdditionalSignInfo;
import kz.akkamal.tinysigner.entities.SignVerResult;
import kz.akkamal.tinysigner.utils.Utils;
import kz.akkamal.tinysigner.view.TableCellRenderer;

public class SignersInfoFrame
extends JDialog {
    private Controller controller;
    private JButton closeBtn;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JPanel signDetailInfo;
    private JTable signDetailTable;
    private JPanel signersPanel;
    private JTable signersTable;
    private JLabel fileNameLabel;
    private JLabel fileNameTextLabel;

    public SignersInfoFrame(Controller controller, Frame parent, boolean modal) {
        super(parent, modal);
        this.controller = controller;
        this.initComponents();
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        void var4_9;
        GroupLayout.Alignment alignment;
        AdditionalSignInfo signVerResult;
        this.setTitle(Utils.getI18nMessage("view.signatures.in.file"));
        this.signersPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.signersTable = new JTable(){

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                return false;
            }
        };
        this.signDetailInfo = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.signDetailTable = new JTable();
        this.closeBtn = new JButton();
        this.fileNameLabel = new JLabel();
        this.fileNameTextLabel = new JLabel();
        this.fileNameLabel.setText(Utils.getI18nMessage("view.file.name.label"));
        this.fileNameTextLabel.setText(this.controller.getModel().getFileName());
        this.fileNameTextLabel.setFont(new Font("Tahoma", 1, 11));
        this.setDefaultCloseOperation(2);
        this.signersPanel.setBorder(BorderFactory.createTitledBorder(Utils.getI18nMessage("view.signers.in.file2")));
        this.signersTable.setBorder(null);
        Object[][] data = new Object[this.controller.getModel().getSignVerResults().size()][3];
        int counter = 0;
        for (AdditionalSignInfo additionalSignInfo : this.controller.getModel().getSignVerResults()) {
            data[counter][0] = additionalSignInfo.getName();
            data[counter][1] = additionalSignInfo.getDate();
            data[counter][2] = additionalSignInfo.getTotalResult();
            ++counter;
        }
        this.signersTable.setModel(new DefaultTableModel(data, new String[]{Utils.getI18nMessage("view.signer.in.file"), Utils.getI18nMessage("view.sign.date"), Utils.getI18nMessage("view.sign.result")}));
        this.signersTable.setSelectionMode(0);
        this.signersTable.setBorder(null);
        this.signersTable.setShowGrid(true);
        this.signersTable.setShowHorizontalLines(true);
        this.signersTable.setShowVerticalLines(false);
        this.signersTable.setRowHeight(19);
        this.signersTable.setDefaultRenderer(Object.class, new TableCellRenderer());
        SignersInfoFrame.setWidthAsPercentages(this.signersTable, 0.6, 0.2, 0.2);
        this.signersTable.getTableHeader().setResizingAllowed(false);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setViewportView(this.signersTable);
        boolean binContains = false;
        Iterator<AdditionalSignInfo> iterator = this.controller.getModel().getSignVerResults().iterator();
        while (iterator.hasNext() && !(binContains = (signVerResult = iterator.next()).getOperationToResult().containsKey(Utils.getI18nMessage("bin")))) {
        }
        if (binContains) {
            int n = 213;
            alignment = GroupLayout.Alignment.LEADING;
        } else {
            int n = 172;
            alignment = GroupLayout.Alignment.BASELINE;
        }
        this.signDetailTable.setRowHeight(20);
        this.signDetailTable.setEnabled(false);
        this.signDetailTable.setShowGrid(true);
        this.signDetailTable.setShowVerticalLines(false);
        this.signDetailTable.setShowHorizontalLines(true);
        this.signDetailTable.setPreferredScrollableViewportSize(this.signDetailTable.getPreferredSize());
        this.signDetailTable.setTableHeader(null);
        this.jScrollPane2.setViewportView(this.signDetailTable);
        this.jScrollPane2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane2.setViewportBorder(null);
        this.jScrollPane2.setOpaque(false);
        this.jScrollPane2.getViewport().setOpaque(false);
        this.signDetailTable.setOpaque(false);
        ((DefaultTableCellRenderer)this.signDetailTable.getDefaultRenderer(Object.class)).setOpaque(false);
        GroupLayout signersPanelLayout = new GroupLayout(this.signersPanel);
        this.signersPanel.setLayout(signersPanelLayout);
        signersPanelLayout.setHorizontalGroup(signersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signersPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jScrollPane1)));
        signersPanelLayout.setVerticalGroup(signersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 123, Short.MAX_VALUE));
        this.signDetailInfo.setBorder(BorderFactory.createTitledBorder(Utils.getI18nMessage("view.sign.verifying.details")));
        GroupLayout signDetailInfoLayout = new GroupLayout(this.signDetailInfo);
        this.signDetailInfo.setLayout(signDetailInfoLayout);
        signDetailInfoLayout.setHorizontalGroup(signDetailInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signDetailInfoLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jScrollPane2, -1, 703, Short.MAX_VALUE)));
        signDetailInfoLayout.setVerticalGroup(signDetailInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signDetailInfoLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, (int)var4_9, Short.MAX_VALUE)));
        this.closeBtn.setText(Utils.getI18nMessage("view.close.label"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signDetailInfo, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.signersPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.closeBtn, -2, 107, -2)).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.fileNameLabel, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileNameTextLabel, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(alignment).addComponent(this.fileNameLabel).addComponent(this.fileNameTextLabel)).addGap(10, 10, 10).addComponent(this.signersPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.signDetailInfo, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeBtn).addGap(10, 10, 10)));
        this.signersTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SignersInfoFrame.this.clearSignInfoTable();
                AdditionalSignInfo currentSignInfo = null;
                for (AdditionalSignInfo signVerResult : SignersInfoFrame.this.controller.getModel().getSignVerResults()) {
                    String name = (String)SignersInfoFrame.this.signersTable.getValueAt(SignersInfoFrame.this.signersTable.getSelectedRow(), 0);
                    String date = (String)SignersInfoFrame.this.signersTable.getValueAt(SignersInfoFrame.this.signersTable.getSelectedRow(), 1);
                    SignVerResult result = (SignVerResult)((Object)SignersInfoFrame.this.signersTable.getValueAt(SignersInfoFrame.this.signersTable.getSelectedRow(), 2));
                    if (!signVerResult.getName().equals(name) || !signVerResult.getDate().equals(date) || signVerResult.getTotalResult() != result) continue;
                    currentSignInfo = signVerResult;
                    break;
                }
                if (currentSignInfo != null) {
                    SignersInfoFrame.this.prepareSignInfoTable(currentSignInfo);
                }
            }
        });
        this.closeBtn.addActionListener(actionEvent -> this.dispatchEvent(new WindowEvent(this, 201)));
        this.pack();
        this.setLocationRelativeTo(null);
        this.signersTable.setRowSelectionInterval(0, 0);
    }

    private void clearSignInfoTable() {
        this.signDetailTable.setModel(new DefaultTableModel(new Object[][]{{null, null}}, new String[]{"1", "2"}));
        this.signDetailTable.repaint();
        this.jScrollPane1.updateUI();
    }

    private void prepareSignInfoTable(AdditionalSignInfo currentSignInfo) {
        Map<String, Object> operationToResult = currentSignInfo.getOperationToResult();
        Object[][] data = new Object[operationToResult.size()][2];
        int counter = 0;
        for (Map.Entry<String, Object> pair : operationToResult.entrySet()) {
            data[counter][0] = pair.getKey();
            data[counter][1] = pair.getValue() instanceof SignVerResult ? ((SignVerResult)((Object)pair.getValue())).getResult() : pair.getValue();
            ++counter;
        }
        this.signDetailTable.setModel(new DefaultTableModel(data, new String[]{"1", "2"}));
    }

    private static void setWidthAsPercentages(JTable table, double ... percentages) {
        double factor = 10000.0;
        TableColumnModel model = table.getColumnModel();
        for (int columnIndex = 0; columnIndex < percentages.length; ++columnIndex) {
            TableColumn column = model.getColumn(columnIndex);
            column.setPreferredWidth((int)(percentages[columnIndex] * 10000.0));
        }
    }
}

