/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import kz.akkamal.tinysigner.model.Model;
import kz.akkamal.tinysigner.utils.FileManageUtil;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.utils.CMSUtil;

public class Utils {
    public static Locale locale;

    public static double convertBytesToKb(int bytes) {
        return (double)bytes / 1024.0;
    }

    public static String readAppVers() throws IOException {
        Properties prop = new Properties();
        InputStream inputStream = Utils.class.getClassLoader().getResourceAsStream("/vers.props");
        if (inputStream != null) {
            prop.load(inputStream);
            String appVersion = prop.getProperty("appVersion");
            return appVersion;
        }
        return null;
    }

    public static void extractContentFromSignature(String cmsPath, Model model) throws IOException, CMSException {
        byte[] cmsBytes = FileManageUtil.readFileFrom(cmsPath);
        CMSSignedData signedData = CMSUtil.parseAsCMS((byte[])cmsBytes);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        signedData.getSignedContent().write((OutputStream)bos);
        String contentFilePath = cmsPath.replace(".cms", "");
        FileManageUtil.writeFileTo(contentFilePath, bos.toByteArray());
        model.setSaveToPath(contentFilePath);
        model.setCmsPath(cmsPath);
    }

    public static String getI18nMessage(String key) {
        return ResourceBundle.getBundle("i18n/messages", locale).getString(key);
    }
}

