/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.service.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import kz.akkamal.tinysigner.common.BundleProvider;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;

public class Signature
implements SignatureInterface {
    private KeyStore keyStore;
    private char[] passwd;
    private String certAlias;

    public Signature(KeyStore keyStore, char[] keyStorePassword, String appCertificateAlias) throws KeyStoreException, CertificateNotYetValidException, CertificateExpiredException {
        Certificate certificate = keyStore.getCertificate(appCertificateAlias);
        if (certificate instanceof X509Certificate) {
            ((X509Certificate)certificate).checkValidity();
        }
        this.keyStore = keyStore;
        this.passwd = keyStorePassword;
        this.certAlias = appCertificateAlias;
    }

    @Override
    public byte[] sign(InputStream content) throws IOException {
        try {
            SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)this.keyStore, (String)this.certAlias, (char[])this.passwd);
            CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])IOUtils.toByteArray(content), (boolean)false, (Provider)BundleProvider.KALKAN.getProvider());
            TSAProfile tsaProfile = new TSAProfile();
            tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
            tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
            tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
            cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKAN.getProvider());
            return cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

