/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.service.pdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kz.akkamal.tinysigner.entities.AdditionalSignInfo;
import kz.akkamal.tinysigner.exception.ClientException;
import kz.akkamal.tinysigner.exception.SignatureVerifyingException;
import kz.akkamal.tinysigner.model.Model;
import kz.akkamal.tinysigner.service.SignatureService;
import kz.akkamal.tinysigner.service.pdf.Signature;
import kz.akkamal.tinysigner.utils.FileManageUtil;
import kz.akkamal.tinysigner.utils.Utils;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessableByteArray;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.reference.KNCACertificateType;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;

public class PdfSignatureService
extends SignatureService {
    public PdfSignatureService(KNCACertificateType signType) {
        super(signType);
    }

    @Override
    public byte[] sign(Model model, byte[] fileBytes) throws ClientException {
        PDDocument doc = null;
        try {
            Signature signature = new Signature(model.getKeyStorageInfo().getKeyStore(), model.getKeyStorageInfo().getPassword(), model.getKeyStorageInfo().getAlias());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc = PDDocument.load(new ByteArrayInputStream(fileBytes));
            PDSignature pdSignature = new PDSignature();
            pdSignature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
            pdSignature.setSubFilter(PDSignature.SUBFILTER_ADBE_PKCS7_DETACHED);
            pdSignature.setName("jvmfy");
            pdSignature.setSignDate(Calendar.getInstance());
            doc.addSignature(pdSignature, signature);
            doc.saveIncremental(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            throw new ClientException(Utils.getI18nMessage("pdf.sign.process.error"), e);
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void verify(Model model) throws SignatureVerifyingException {
        PDDocument document = null;
        try {
            File signedFile = new File(model.getSaveToPath());
            document = PDDocument.load(signedFile);
            List<PDSignature> signatureDictionaries = document.getSignatureDictionaries();
            ArrayList<AdditionalSignInfo> signersAddInfo = new ArrayList<AdditionalSignInfo>();
            for (PDSignature signatureDictionary : signatureDictionaries) {
                byte[] pdf = FileManageUtil.readFileFrom(signedFile.getAbsolutePath());
                byte[] signatureContent = signatureDictionary.getContents(pdf);
                byte[] signedContent = signatureDictionary.getSignedContent(pdf);
                CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(signedContent), signatureContent);
                this.internalVerifyProcess(signedData, model);
                signersAddInfo.addAll(model.getSignVerResults());
            }
            model.setSignVerResults(signersAddInfo);
        }
        catch (Exception e) {
            throw new SignatureVerifyingException(Utils.getI18nMessage("pdf.sign.extract.error"), e);
        }
        finally {
            if (document != null) {
                try {
                    document.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

