/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.service;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.common.BundleProvider;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.entities.AdditionalSignInfo;
import kz.akkamal.tinysigner.entities.SignVerResult;
import kz.akkamal.tinysigner.entities.request.CertType;
import kz.akkamal.tinysigner.exception.ClientException;
import kz.akkamal.tinysigner.exception.SignatureVerifyingException;
import kz.akkamal.tinysigner.model.Model;
import kz.akkamal.tinysigner.utils.KNCAOcspChecker;
import kz.akkamal.tinysigner.utils.Utils;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.ess.ESSCertIDv2;
import kz.gov.pki.kalkan.asn1.ess.SigningCertificateV2;
import kz.gov.pki.kalkan.asn1.pkcs.PKCSObjectIdentifiers;
import kz.gov.pki.kalkan.asn1.x509.X509Name;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.kalkan.exception.OCSPCode;
import kz.gov.pki.kalkan.jce.exception.ExtCertPathValidatorException;
import kz.gov.pki.kalkan.jce.provider.KalkanProvider;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.kalkan.jce.provider.cms.SignerInformation;
import kz.gov.pki.kalkan.tsp.TimeStampToken;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.PKIXUtil;
import kz.gov.pki.provider.utils.TSPUtil;
import kz.gov.pki.provider.utils.X509Util;
import kz.gov.pki.provider.utils.verifier.Verifier;
import kz.gov.pki.provider.utils.verifier.VerifierFlags;
import kz.gov.pki.provider.utils.verifier.VerifierType;
import kz.gov.pki.provider.utils.verifier.VerifyX509CertifcateResult;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KeyUsageType;

public abstract class SignatureService {
    private static Provider currentProvider = new KalkanProvider();
    private final KNCACertificateType signType;
    private Collection<X509Certificate> caCertList;
    private Map<X500Principal, X509Certificate> caCertsMap;
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");

    public SignatureService(KNCACertificateType signType) {
        this.signType = signType;
    }

    public abstract byte[] sign(Model var1, byte[] var2) throws ClientException;

    public abstract void verify(Model var1) throws SignatureVerifyingException;

    public VerifyX509CertifcateResult validateCertificate(X509Certificate cert, Date signDate, Model model) throws ClientException {
        try {
            block15: {
                if (!X509Util.getKNCACertificateType((X509Certificate)cert).contains(this.signType)) {
                    throw new ClientException(Utils.getI18nMessage("key.not.for.signature.error"));
                }
                try {
                    PKIXUtil pkixUtil = new PKIXUtil(cert, this.getCaCertList());
                    if (signDate != null) {
                        pkixUtil.withDate(signDate);
                    }
                    pkixUtil.validate();
                }
                catch (ProviderUtilException pue) {
                    BundleLog.LOG.error(pue.getMessage(), pue);
                    if (pue.getCause() != null && pue.getCause() instanceof CertPathBuilderException) {
                        CertPathBuilderException e = (CertPathBuilderException)pue.getCause();
                        String errorMessage = this.getErrorMessageFromCertPathBuilderException(e);
                        throw new ClientException(errorMessage);
                    }
                    if (pue.getCode().equals((Object)ProviderUtilExceptionCode.ISSUER_CERT_NOT_FOUND)) {
                        throw new ClientException(Utils.getI18nMessage("cert.issuer.not.found.error"));
                    }
                    throw new ClientException(pue.getCode().toString());
                }
                if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1.2") || X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.5.19.1.2.2.1")) {
                    throw new ClientException(Utils.getI18nMessage("key.not.for.signature.error"));
                }
                try {
                    KNCAOcspChecker checker = new KNCAOcspChecker(this.getCaCertsMap());
                    checker.check(cert);
                }
                catch (CertPathValidatorException e) {
                    BundleLog.LOG.error("error during cert checking", e);
                    if (!(e.getCause() instanceof KalkanException)) break block15;
                    KalkanException ke = (KalkanException)e.getCause();
                    if (ke.getErrorCode() == OCSPCode.STATUS_REVOKED) {
                        throw new ClientException(Utils.getI18nMessage("cert.revoked.error"));
                    }
                    if (ke.getErrorCode() == OCSPCode.STATUS_UNKNOWN) {
                        throw new ClientException(Utils.getI18nMessage("cert.status.unknown.error"));
                    }
                    if (ke.getErrorCode() == OCSPCode.OCSP_RESP_NOT_VERIFIED) {
                        throw new ClientException(Utils.getI18nMessage("oscp.resp.not.verified.error"));
                    }
                    throw new ClientException(ke.getErrorCode() + "");
                }
            }
            String flag = this.signType == KNCACertificateType.AUTHENTICATION ? "AUTH" : "SIGNATURE";
            VerifierFlags verifierFlags = new VerifierFlags(flag);
            verifierFlags.removeVerifyerType(VerifierType.X509CERTIFICATE_VALIDITY_WITH_STATUS);
            VerifyX509CertifcateResult verifyX509CertifcateResult = Verifier.verifyX509Certificate((X509Certificate)cert, this.getCaCertList(), (VerifierFlags)verifierFlags);
            this.checkAdditionalCertParameters(verifyX509CertifcateResult, model);
            return verifyX509CertifcateResult;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException(Utils.getI18nMessage("cert.verifying.error"), e);
        }
    }

    public KNCACertificateType getSignType() {
        return this.signType;
    }

    private void checkAdditionalCertParameters(VerifyX509CertifcateResult certInfo, Model model) throws CertificateParsingException, ClientException {
        String iin = model.getRequiredIin();
        String bin = model.getRequiredBin();
        String[] oids = model.getOids();
        CertType certType = model.getCertType();
        if (certType != null) {
            switch (certType) {
                case LEGAL: {
                    if (!certInfo.isPersonCert()) break;
                    throw new ClientException(Utils.getI18nMessage("cert.type.incorrect"));
                }
                case PERSONAL: {
                    if (certInfo.isPersonCert()) break;
                    throw new ClientException(Utils.getI18nMessage("cert.type.incorrect"));
                }
            }
        }
        if (certInfo.isPersonCert()) {
            if (bin != null && !bin.isEmpty()) {
                throw new ClientException(Utils.getI18nMessage("bin.with.personal.cert.error"));
            }
            if (oids != null && oids.length > 0) {
                throw new ClientException(Utils.getI18nMessage("role.with.personal.cert.error"));
            }
        }
        if (iin != null && !iin.isEmpty() && !iin.equals(certInfo.getIin())) {
            throw new ClientException(Utils.getI18nMessage("cert.iin.incorrect"));
        }
        if (bin != null && !bin.isEmpty() && !bin.equals(certInfo.getBin())) {
            throw new ClientException(Utils.getI18nMessage("cert.bin.incorrect"));
        }
        if (oids != null && oids.length > 0) {
            boolean oidFound = false;
            for (String oid : oids) {
                if (!X509Util.containsExtKeyUsage((X509Certificate)certInfo.getX509Certificate(), (String)oid)) continue;
                oidFound = true;
                break;
            }
            if (!oidFound) {
                throw new ClientException(Utils.getI18nMessage("cert.role.incorrect"));
            }
        }
    }

    private String getErrorMessageFromCertPathBuilderException(CertPathBuilderException e) {
        if (e.getCause() != null && e.getCause() instanceof ExtCertPathValidatorException) {
            CertPathValidatorException eee;
            ExtCertPathValidatorException ee = (ExtCertPathValidatorException)e.getCause();
            if (ee.getCause() != null && ee.getCause() instanceof CertificateExpiredException) {
                return Utils.getI18nMessage("cert.expired.error");
            }
            if (ee.getCause() != null && ee.getCause() instanceof CertificateNotYetValidException) {
                return Utils.getI18nMessage("cert.not.valid.yet.error");
            }
            if (ee.getCause() != null && ee.getCause() instanceof CertPathValidatorException && (eee = (CertPathValidatorException)ee.getCause()).getCause() != null && eee.getCause() instanceof KalkanException) {
                KalkanException ke = (KalkanException)eee.getCause();
                if (ke.getErrorCode().equals(OCSPCode.STATUS_REVOKED)) {
                    return Utils.getI18nMessage("cert.revoked.error");
                }
                if (ke.getErrorCode().equals(OCSPCode.STATUS_UNKNOWN)) {
                    return Utils.getI18nMessage("cert.status.unknown.error");
                }
            }
        }
        if (e.getCause() != null && e.getCause() instanceof InvalidKeyException) {
            return Utils.getI18nMessage("key.verifying.error");
        }
        return Utils.getI18nMessage("cert.path.verifying.error");
    }

    protected void internalVerifyProcess(CMSSignedData signedData, Model model) throws ClientException {
        CertStore certs = null;
        try {
            certs = signedData.getCertificatesAndCRLs("Collection", currentProvider.getName());
        }
        catch (Exception e) {
            throw new ClientException(Utils.getI18nMessage("cert.extract.error"));
        }
        ArrayList<AdditionalSignInfo> signersAddInfo = new ArrayList<AdditionalSignInfo>();
        Collection signers = signedData.getSignerInfos().getSigners();
        Iterator it = signers.iterator();
        while (it.hasNext()) {
            AdditionalSignInfo additionalSignInfo = new AdditionalSignInfo();
            LinkedHashMap<String, Object> operationToResult = new LinkedHashMap<String, Object>();
            SignerInformation signerInfo = (SignerInformation)it.next();
            String signerName = null;
            X509Certificate certificate = null;
            try {
                certificate = (X509Certificate)certs.getCertificates((CertSelector)signerInfo.getSID()).iterator().next();
                X509Name x509Name = new X509Name(certificate.getSubjectDN().getName());
                HashMap mapRdnOidValue = X509Util.getRDNMapWithArrayValues((X509Name)x509Name);
                String[] cn = (String[])mapRdnOidValue.get(X509Name.CN.getId());
                String name = null;
                if (cn != null && cn.length > 0) {
                    name = cn[0].trim();
                }
                String[] g = (String[])mapRdnOidValue.get(X509Name.GIVENNAME.getId());
                signerName = (name == null ? "" : name + " ") + g[0];
                additionalSignInfo.setName(signerName);
            }
            catch (CertStoreException e) {
                BundleLog.LOG.error("error during sign cert getting", e);
                additionalSignInfo.setName(Utils.getI18nMessage("unknown"));
                additionalSignInfo.setTotalResult(SignVerResult.FAILED);
                operationToResult.put(Utils.getI18nMessage("cert.extract.process"), (Object)SignVerResult.FAILED);
            }
            try {
                SigningCertificateV2 sigCertV2;
                ESSCertIDv2 essCertIDv2;
                byte[] certHash;
                AttributeTable sat = signerInfo.getSignedAttributes();
                Attribute sigCertV2Attr = sat.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
                if (sigCertV2Attr != null && !Arrays.equals(certHash = MessageDigest.getInstance((essCertIDv2 = (sigCertV2 = SigningCertificateV2.getInstance((Object)sigCertV2Attr.getAttrValues().getObjectAt(0))).getCerts()[0]).getHashAlgorithm().getObjectId().getId(), currentProvider).digest(certificate.getEncoded()), essCertIDv2.getCertHash())) {
                    throw new ProviderUtilException(ProviderUtilExceptionCode.CMS_ESSCERTIDV2_DIFF_CERTHASH);
                }
                signerInfo.verify(certificate, currentProvider.getName());
                operationToResult.put(Utils.getI18nMessage("sign.verifying.result"), (Object)SignVerResult.OK);
            }
            catch (Exception e) {
                BundleLog.LOG.error("error during sign verifying", e);
                additionalSignInfo.setTotalResult(SignVerResult.FAILED);
                operationToResult.put(Utils.getI18nMessage("sign.verifying.result"), (Object)SignVerResult.FAILED);
            }
            Date signDate = null;
            try {
                TimeStampToken tsp = CMSUtil.getTimestampToken((SignerInformation)signerInfo, (Provider)currentProvider);
                signDate = tsp.getTimeStampInfo().getGenTime();
                TSPUtil.validateTimeStampToken((TimeStampToken)tsp, (byte[])signerInfo.getSignature(), (Provider)currentProvider);
                operationToResult.put(Utils.getI18nMessage("tsp.verifying.result"), (Object)SignVerResult.OK);
                additionalSignInfo.setDate(this.simpleDateFormat.format(signDate));
            }
            catch (Exception e) {
                BundleLog.LOG.error("error during tsp validationg", e);
                additionalSignInfo.setTotalResult(SignVerResult.FAILED);
                operationToResult.put(Utils.getI18nMessage("tsp.verifying.result"), (Object)SignVerResult.FAILED);
            }
            if (!X509Util.containsKeyUsage((X509Certificate)certificate, (KeyUsageType)KeyUsageType.NONREPUDIATION) || !X509Util.containsKeyUsage((X509Certificate)certificate, (KeyUsageType)KeyUsageType.DIGITAL_SIGNATURE)) {
                BundleLog.LOG.error("invalid sign cert key usage", new Exception());
                additionalSignInfo.setTotalResult(SignVerResult.FAILED);
                operationToResult.put(Utils.getI18nMessage("cert.verifying.result"), (Object)SignVerResult.FAILED);
            }
            try {
                if (!X509Util.getKNCACertificateType((X509Certificate)certificate).contains(this.signType)) {
                    throw new ClientException("invalid cert type");
                }
                VerifyX509CertifcateResult verifyX509CertifcateResult = this.validateCertificate(certificate, signDate, model);
                this.fillCertInfo(verifyX509CertifcateResult, operationToResult, signDate, signerName);
                operationToResult.put(Utils.getI18nMessage("cert.verifying.result"), (Object)SignVerResult.OK);
            }
            catch (Exception e) {
                BundleLog.LOG.error("error during sign cert checking", e);
                additionalSignInfo.setTotalResult(SignVerResult.FAILED);
                operationToResult.put(Utils.getI18nMessage("cert.verifying.result"), (Object)SignVerResult.FAILED);
            }
            if (additionalSignInfo.getTotalResult() == null) {
                additionalSignInfo.setTotalResult(SignVerResult.OK);
            }
            additionalSignInfo.setOperationToResult(operationToResult);
            signersAddInfo.add(additionalSignInfo);
        }
        model.setSignVerResults(signersAddInfo);
    }

    private void fillCertInfo(VerifyX509CertifcateResult verifyX509CertifcateResult, Map<String, Object> operationToResult, Date signDate, String signerName) throws CertificateParsingException {
        X509Certificate cert = verifyX509CertifcateResult.getX509Certificate();
        operationToResult.put(Utils.getI18nMessage("signer"), signerName);
        operationToResult.put(Utils.getI18nMessage("iin"), verifyX509CertifcateResult.getIin());
        if (!verifyX509CertifcateResult.isPersonCert()) {
            operationToResult.put(Utils.getI18nMessage("bin"), verifyX509CertifcateResult.getBin());
            String authority = null;
            if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.2.1")) {
                authority = Utils.getI18nMessage("nca.administrator");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.2.2")) {
                authority = Utils.getI18nMessage("nca.manager");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.2.3")) {
                authority = Utils.getI18nMessage("nca.operator");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.1")) {
                authority = Utils.getI18nMessage("nca.first.leader");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.2")) {
                authority = Utils.getI18nMessage("nca.sign.rights");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.3")) {
                authority = Utils.getI18nMessage("nca.fin.doc.sign.rights");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.4")) {
                authority = Utils.getI18nMessage("nca.human.resource");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.5")) {
                authority = Utils.getI18nMessage("nca.org.employee");
            } else if (X509Util.containsExtKeyUsage((X509Certificate)cert, (String)"1.2.398.3.3.4.1.2.6")) {
                authority = Utils.getI18nMessage("nca.iis");
            }
            operationToResult.put(Utils.getI18nMessage("nca.role"), authority);
        }
        operationToResult.put(Utils.getI18nMessage("cert.sn"), verifyX509CertifcateResult.getSerialNumber());
        X509Certificate x509Certificate = cert;
        String from = this.simpleDateFormat.format(x509Certificate.getNotBefore());
        String to = this.simpleDateFormat.format(x509Certificate.getNotAfter());
        operationToResult.put(Utils.getI18nMessage("cert.exp.date"), from + " - " + to);
        operationToResult.put(Utils.getI18nMessage("sign.date"), this.simpleDateFormat.format(signDate));
    }

    private Collection<X509Certificate> getCaCertList() {
        if (this.caCertList == null) {
            this.caCertList = new ArrayList<X509Certificate>();
            char[] pwd = "123456".toCharArray();
            try (InputStream in = Controller.class.getResource("/keystore.jks").openStream();){
                KeyStore store = KeyStore.getInstance("JKS", BundleProvider.KALKAN.getProvider());
                store.load(in, pwd);
                Enumeration<String> aliases = store.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)store.getCertificate(alias);
                    if (cert == null) continue;
                    this.caCertList.add(cert);
                }
            }
            catch (Exception x) {
                BundleLog.LOG.error(x.getMessage(), x);
            }
        }
        return this.caCertList;
    }

    private Map<X500Principal, X509Certificate> getCaCertsMap() {
        if (this.caCertsMap == null) {
            this.caCertsMap = new HashMap<X500Principal, X509Certificate>();
            for (X509Certificate X509cert : this.getCaCertList()) {
                this.caCertsMap.put(X509cert.getSubjectX500Principal(), X509cert);
            }
        }
        return this.caCertsMap;
    }

    static {
        Security.addProvider(currentProvider);
    }
}

