/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.service;

import java.security.KeyStore;
import java.security.Provider;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.common.BundleProvider;
import kz.akkamal.tinysigner.exception.ClientException;
import kz.akkamal.tinysigner.exception.SignatureVerifyingException;
import kz.akkamal.tinysigner.model.Model;
import kz.akkamal.tinysigner.service.SignatureService;
import kz.akkamal.tinysigner.utils.FileManageUtil;
import kz.akkamal.tinysigner.utils.Utils;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedData;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.CMSUtil;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.provider.utils.model.SigningEntity;
import kz.gov.pki.provider.utils.model.TSAProfile;
import kz.gov.pki.reference.KNCACertificateType;
import kz.gov.pki.reference.KNCAServiceRequestMethod;
import kz.gov.pki.reference.KalkanHashAlgorithm;
import kz.gov.pki.reference.TSAPolicy;

public class CmsSignatureService
extends SignatureService {
    public CmsSignatureService(KNCACertificateType signType) {
        super(signType);
    }

    @Override
    public byte[] sign(Model model, byte[] fileBytes) throws ClientException {
        try {
            SigningEntity signingEntity = KeyStoreUtil.getSigningEntity((KeyStore)model.getKeyStorageInfo().getKeyStore(), (String)model.getKeyStorageInfo().getAlias(), (char[])model.getKeyStorageInfo().getPassword());
            CMSSignedData cmsSignedData = CMSUtil.createCAdES((SigningEntity)signingEntity, (byte[])fileBytes, (!model.isDetached() ? 1 : 0) != 0, (Provider)BundleProvider.KALKAN.getProvider());
            TSAProfile tsaProfile = new TSAProfile();
            tsaProfile.setHashAlgorithm(KalkanHashAlgorithm.HASH_SHA256);
            tsaProfile.setRequestMethod(KNCAServiceRequestMethod.GET);
            tsaProfile.setTsaPolicy(TSAPolicy.TSA_RSA);
            cmsSignedData = CMSUtil.applyCAdEST((CMSSignedData)cmsSignedData, (SigningEntity)signingEntity, (TSAProfile)tsaProfile, (Provider)BundleProvider.KALKAN.getProvider());
            return cmsSignedData.getEncoded();
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(Utils.getI18nMessage("sign.process.error.with.code") + " " + e.getCode().name(), e);
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(Utils.getI18nMessage("sign.process.error"), e);
        }
    }

    @Override
    public void verify(Model model) throws SignatureVerifyingException {
        try {
            CMSSignedData signedData = CMSUtil.parseAsCMS((byte[])FileManageUtil.readFileFrom(model.getCmsPath()));
            if (signedData.getSignedContent() == null) {
                throw new SignatureVerifyingException(Utils.getI18nMessage("cms.no.data"));
            }
            this.internalVerifyProcess(signedData, model);
        }
        catch (Exception e) {
            throw new SignatureVerifyingException(Utils.getI18nMessage("cades.format.error"), e);
        }
    }
}

