/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.entities;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.smartcardio.CardException;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.view.StorageToViewTranslator;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.exception.KalkanException;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KeyStoreEntry;

public class KeyStorageInfo {
    private String alias;
    private String container;
    private String password;
    private KeyStore keyStore;
    private Storage storage;
    private Map<String, KeyStoreEntry> availableKeys;

    public KeyStorageInfo(String storageName) {
        String storage = StorageToViewTranslator.viewToStorage(storageName);
        this.storage = Storage.get((String)storage);
    }

    public static List<String> getAllAvailableStorageTypes() {
        ArrayList<String> availableStorageTypes = new ArrayList<String>();
        availableStorageTypes.add(Storage.PKCS12.getName());
        for (Storage storage : Storage.values()) {
            try {
                if (KeyStoreUtil.loadSlotList((Storage)storage).isEmpty()) continue;
                availableStorageTypes.add(storage.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return availableStorageTypes;
    }

    public List<String> getContainers() {
        ArrayList<String> containers = new ArrayList<String>();
        try {
            for (String tName : KeyStoreUtil.loadSlotList((Storage)this.storage)) {
                containers.add(tName);
            }
        }
        catch (CardException | KalkanException | ProviderUtilException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        return containers;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public char[] getPassword() {
        return this.password != null ? this.password.toCharArray() : null;
    }

    public void setPassword(String password) {
        this.password = password != null ? password.trim() : null;
    }

    public Map<String, KeyStoreEntry> getAvailableKeys() {
        return this.availableKeys;
    }

    public void setAvailableKeys(Map<String, KeyStoreEntry> availableKeys) {
        this.availableKeys = availableKeys;
    }
}

