/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.entities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class KeyPathsInfo {
    private static final String infoPath;
    private static final Properties settings;

    private static String getValue(String key) throws Exception {
        try (FileInputStream fis = new FileInputStream(infoPath);){
            settings.load(fis);
            String string = settings.getProperty(key);
            return string;
        }
    }

    public static void updatePath(PathType pathType, String path) throws Exception {
        try (FileOutputStream out = new FileOutputStream(infoPath);){
            String key = null;
            switch (pathType) {
                case SIGN_KEY_PATH: {
                    key = "sign.key";
                    break;
                }
                case AUTH_KEY_PATH: {
                    key = "auth.key";
                }
            }
            if (key != null) {
                settings.setProperty(key, path);
                settings.store(out, null);
            }
        }
    }

    public static String getPath(PathType pathType) throws Exception {
        switch (pathType) {
            case AUTH_KEY_PATH: {
                return KeyPathsInfo.getValue("auth.key");
            }
            case SIGN_KEY_PATH: {
                return KeyPathsInfo.getValue("sign.key");
            }
            case AUTH_KEY_DIRECTORY: {
                String fullPath = KeyPathsInfo.getValue("auth.key");
                return fullPath.substring(0, fullPath.lastIndexOf(File.separator));
            }
            case SIGN_KEY_DIRECTORY: {
                String fullPath = KeyPathsInfo.getValue("sign.key");
                return fullPath.substring(0, fullPath.lastIndexOf(File.separator));
            }
        }
        return null;
    }

    static {
        String TEMP_DIR = System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") : System.getProperty("java.io.tmpdir") + File.separator;
        infoPath = TEMP_DIR + "tinysign/infoPath.properties";
        settings = new Properties();
    }

    public static enum PathType {
        AUTH_KEY_DIRECTORY,
        AUTH_KEY_PATH,
        SIGN_KEY_DIRECTORY,
        SIGN_KEY_PATH;

    }
}

