/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.controller.filemanager;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.UUID;
import javax.net.ssl.SSLHandshakeException;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.controller.filemanager.FileManager;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.utils.Utils;

public class RemoteFileManager
extends FileManager {
    public RemoteFileManager(String source, String saveTo, String filename) throws Exception {
        super(source, saveTo, filename);
        URL fileDownloadUrl = new URL(source);
        URI uri = new URI(fileDownloadUrl.getProtocol(), fileDownloadUrl.getUserInfo(), IDN.toASCII(fileDownloadUrl.getHost()), fileDownloadUrl.getPort(), fileDownloadUrl.getPath(), fileDownloadUrl.getQuery(), fileDownloadUrl.getRef());
        String correctEncodedURL = uri.toASCIIString();
        this.fileInfo.setSource(correctEncodedURL);
        new URL(correctEncodedURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        RandomAccessFile file = null;
        InputStream stream = null;
        try {
            URL fileDownloadUrl = new URL(this.fileInfo.getSource());
            HttpURLConnection connection = (HttpURLConnection)fileDownloadUrl.openConnection();
            connection.setRequestProperty("Accept-Encoding", "identity");
            connection.setRequestProperty("Range", "bytes=" + this.getFileInfo().getProceed() + "-");
            connection.connect();
            if (connection.getResponseCode() / 100 != 2) {
                switch (connection.getResponseCode()) {
                    case 400: {
                        this.getFileInfo().setErrorCode(ErrorCode.INVALID_REQUEST.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.incorrect.request"));
                        return;
                    }
                    case 401: 
                    case 403: {
                        this.getFileInfo().setErrorCode(ErrorCode.RESOURCE_ACCESS_ERROR.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.resource.access.error"));
                        return;
                    }
                    case 404: {
                        this.getFileInfo().setErrorCode(ErrorCode.RESOURCE_NOT_FOUND.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.resource.not.found"));
                        return;
                    }
                    case 500: {
                        this.getFileInfo().setErrorCode(ErrorCode.INTERNAL_NETWORK_ERROR.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.internal.server.error"));
                        return;
                    }
                    case 503: {
                        this.getFileInfo().setErrorCode(ErrorCode.SERVER_UNAVAILABLE.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.server.unavailable"));
                        return;
                    }
                    default: {
                        this.getFileInfo().setErrorCode(ErrorCode.GENERAL_NETWORK_ERROR.getErrorCode());
                        this.error(Utils.getI18nMessage("downloader.general.network.error.with.code") + " " + connection.getResponseCode());
                        return;
                    }
                }
            }
            int contentLength = connection.getContentLength();
            if (contentLength < 1) {
                this.changeProgressBarType();
            }
            if (this.getFileInfo().getFilename() == null) {
                String raw = connection.getHeaderField("Content-Disposition");
                String fileName = raw != null && raw.indexOf("=") != -1 ? raw.split("=")[1].replaceAll("\"", "") : UUID.randomUUID().toString().substring(10);
                this.fileInfo.setFilename(fileName);
            }
            this.fileInfo.setPathToSave(this.fileInfo.getPathToSave() + File.separator + System.currentTimeMillis() + "_" + this.fileInfo.getFilename());
            if (this.fileInfo.getSize() == -1) {
                this.fileInfo.setSize(contentLength);
                this.stateChanged();
            }
            file = new RandomAccessFile(this.fileInfo.getPathToSave(), "rw");
            file.seek(this.fileInfo.getProceed());
            stream = connection.getInputStream();
            if (!this.fileInfo.isUnknownContentLength()) {
                int diff;
                byte[] buffer;
                int read;
                while (this.fileInfo.getStatus() == FileManager.ProcessStatus.IN_PROCESS && (read = stream.read(buffer = (diff = this.fileInfo.getSize() - this.fileInfo.getProceed()) > 1024 ? new byte[1024] : new byte[diff])) != -1) {
                    file.write(buffer, 0, read);
                    this.fileInfo.setProceed(this.fileInfo.getProceed() + read);
                    this.stateChanged();
                }
            } else {
                try (BufferedInputStream inputStream = new BufferedInputStream(stream);){
                    int byteContent;
                    byte[] data = new byte[1024];
                    while ((byteContent = inputStream.read(data, 0, 1024)) != -1) {
                        file.write(data, 0, byteContent);
                        this.fileInfo.setProceed(this.fileInfo.getProceed() + byteContent);
                        this.stateChanged();
                    }
                }
            }
            if (this.fileInfo.getStatus() != FileManager.ProcessStatus.IN_PROCESS) return;
            this.fileInfo.setStatus(FileManager.ProcessStatus.COMPLETED);
            this.stateChanged();
            return;
        }
        catch (UnknownHostException e) {
            this.fileInfo.setErrorCode(ErrorCode.MALFORMED_URL.getErrorCode());
            this.error(Utils.getI18nMessage("malformed.url"));
            return;
        }
        catch (Throwable e) {
            block59: {
                if (e instanceof SSLHandshakeException) {
                    this.fileInfo.setErrorCode(ErrorCode.SSL_HANDSHAKE_EXCEPTION.getErrorCode());
                    this.error(Utils.getI18nMessage("downloader.ssl.handshake.exception"));
                } else {
                    this.error(Utils.getI18nMessage("downloader.file.downloading.error"));
                }
                BundleLog.LOG.error(e.getMessage(), e);
                if (file == null) break block59;
                try {
                    file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stream == null) return;
            try {
                stream.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void error(String errorMessage) {
        if (this.getFileInfo().getStatus() == FileManager.ProcessStatus.CANCELLED) {
            return;
        }
        this.getFileInfo().setStatus(FileManager.ProcessStatus.ERROR);
        if (this.getFileInfo().getErrorCode() == 0) {
            this.getFileInfo().setErrorCode(ErrorCode.GENERAL_NETWORK_ERROR.getErrorCode());
        }
        this.getFileInfo().setErrorMessage(errorMessage);
        this.stateChanged();
    }

    @Override
    public void cancel() {
        this.fileInfo.setStatus(FileManager.ProcessStatus.CANCELLED);
        this.stateChanged();
    }

    private void changeProgressBarType() {
        this.getFileInfo().setUnknownContentLength(true);
        this.getFileInfo().setStatus(FileManager.ProcessStatus.CHANGE_PROGRESS_BAR);
        this.stateChanged();
        this.getFileInfo().setStatus(FileManager.ProcessStatus.IN_PROCESS);
    }
}

