/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.controller.filemanager;

import com.google.gson.Gson;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.controller.filemanager.FileManager;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.entities.request.AuthParameters;
import kz.akkamal.tinysigner.utils.Utils;

public class JsonDataManager
extends FileManager {
    public JsonDataManager(String source, String saveTo, String filename) throws Exception {
        super(source, saveTo, filename);
    }

    @Override
    protected void error(String errorMessage) {
        this.fileInfo.setStatus(FileManager.ProcessStatus.ERROR);
        this.fileInfo.setErrorMessage(errorMessage);
        this.stateChanged();
    }

    @Override
    public void cancel() {
    }

    @Override
    public void run() {
        Gson gson = new Gson();
        try {
            AuthParameters authParameters = gson.fromJson(this.fileInfo.getSource(), AuthParameters.class);
            if (authParameters.getTarget() == null) {
                throw new Exception("invalid target param");
            }
            this.fileInfo.setFilename(authParameters.getTarget());
            this.fileInfo.setStatus(FileManager.ProcessStatus.IN_PROCESS);
            this.stateChanged();
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.fileInfo.setErrorCode(ErrorCode.INVALID_ARGS.getErrorCode());
            this.error(Utils.getI18nMessage("filemanager.data.args.incorrect"));
        }
        this.fileInfo.setStatus(FileManager.ProcessStatus.COMPLETED);
        this.stateChanged();
    }
}

