/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.controller.filemanager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.controller.filemanager.FileManager;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.utils.Utils;
import kz.gov.pki.kalkan.util.encoders.Base64;

public class Base64FileManager
extends FileManager {
    public Base64FileManager(String source, String saveTo, String filename) {
        super(source, saveTo, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RandomAccessFile file = null;
        InputStream stream = null;
        try {
            int diff;
            byte[] buffer;
            int read;
            byte[] content;
            String header = this.fileInfo.getSource().substring(0, this.fileInfo.getSource().indexOf("base64,"));
            String body = null;
            Pattern pattern = Pattern.compile("base64,(.*)");
            Matcher matcher = pattern.matcher(this.fileInfo.getSource());
            if (matcher.find()) {
                body = matcher.group(1);
            }
            if (body == null || body.replace("base64,", "").trim().isEmpty()) {
                this.fileInfo.setErrorCode(ErrorCode.NO_FILE_FOUND.getErrorCode());
                this.error(Utils.getI18nMessage("filemanager.file.dont.exist"));
                return;
            }
            try {
                content = Base64.decode((String)body);
            }
            catch (Throwable e) {
                this.fileInfo.setErrorCode(ErrorCode.INVALID_FILE_FORMAT.getErrorCode());
                this.error(Utils.getI18nMessage("filemanager.file.encoding.error"));
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.fileInfo.getSize() == -1) {
                this.fileInfo.setSize(content.length);
                this.stateChanged();
            }
            if (this.fileInfo.getFilename() == null) {
                this.fileInfo.setFilename(UUID.randomUUID().toString().substring(10));
            }
            this.fileInfo.setPathToSave(this.fileInfo.getPathToSave() + File.separator + System.currentTimeMillis() + "_" + this.fileInfo.getFilename());
            file = new RandomAccessFile(this.fileInfo.getPathToSave(), "rw");
            file.seek(this.fileInfo.getProceed());
            stream = new ByteArrayInputStream(content);
            while (this.fileInfo.getStatus() == FileManager.ProcessStatus.IN_PROCESS && (read = stream.read(buffer = (diff = this.fileInfo.getSize() - this.fileInfo.getProceed()) > 1024 ? new byte[1024] : new byte[diff])) != -1) {
                file.write(buffer, 0, read);
                this.fileInfo.setProceed(this.fileInfo.getProceed() + read);
                this.stateChanged();
            }
            if (this.fileInfo.getStatus() == FileManager.ProcessStatus.IN_PROCESS) {
                this.fileInfo.setStatus(FileManager.ProcessStatus.COMPLETED);
                this.stateChanged();
            }
        }
        catch (Throwable e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.fileInfo.setErrorCode(ErrorCode.FILE_SAVING_ERROR.getErrorCode());
            this.error(Utils.getI18nMessage("filemanager.file.save.error"));
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception exception) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected void error(String errorMessage) {
        this.fileInfo.setStatus(FileManager.ProcessStatus.ERROR);
        this.fileInfo.setErrorMessage(errorMessage);
        this.stateChanged();
    }

    @Override
    public void cancel() {
        this.fileInfo.setStatus(FileManager.ProcessStatus.CANCELLED);
        this.stateChanged();
    }
}

