/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.controller;

import java.util.concurrent.CountDownLatch;
import kz.akkamal.tinysigner.TinySigner;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.controller.filemanager.Base64FileManager;
import kz.akkamal.tinysigner.entities.SignType;
import kz.akkamal.tinysigner.entities.request.DownloadProgressParameters;
import kz.akkamal.tinysigner.entities.request.SignParameters;

public class ControllerWithDownloadProgressFunctional
extends Controller {
    private LastOperationResult lastOperationResult;

    public ControllerWithDownloadProgressFunctional(SignParameters signParameters, CountDownLatch countDownLatch) {
        super(SignType.DOWNLOAD_PROGRESS_SIGN, signParameters, countDownLatch);
    }

    public void updateDownloadInfo(DownloadProgressParameters parameters) {
        if (this.model.getTotalSize() == 0) {
            this.model.setTotalSize(parameters.getTotalSize());
        }
        this.model.setDownloaded(parameters.getByteDownloaded());
        this.model.setFileName(parameters.getFilename());
        this.view.updateFileInfo();
        this.countDownLatch.countDown();
    }

    public void startSignProcess(SignParameters signParameters) {
        this.fileManager = new Base64FileManager(signParameters.getFileBase64(), TinySigner.saveFileDirectory, signParameters.getFilename());
        this.fileManager.addObserver(this);
        this.fileManager.prepareFile();
    }

    public void setCountDownLatch(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public LastOperationResult getLastOperationResult() {
        return this.lastOperationResult;
    }

    public void setLastOperationResult(LastOperationResult lastOperationResult) {
        this.lastOperationResult = lastOperationResult;
    }

    public static enum LastOperationResult {
        OK,
        FAILED;

    }
}

