/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner.controller;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.Provider;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import kz.akkamal.tinysigner.TinySigner;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.common.BundleProvider;
import kz.akkamal.tinysigner.controller.filemanager.Base64FileManager;
import kz.akkamal.tinysigner.controller.filemanager.FileInfo;
import kz.akkamal.tinysigner.controller.filemanager.FileManager;
import kz.akkamal.tinysigner.controller.filemanager.JsonDataManager;
import kz.akkamal.tinysigner.controller.filemanager.RemoteFileManager;
import kz.akkamal.tinysigner.entities.AdditionalSignInfo;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.entities.KeyPathsInfo;
import kz.akkamal.tinysigner.entities.KeyStorageInfo;
import kz.akkamal.tinysigner.entities.ProcessResult;
import kz.akkamal.tinysigner.entities.SignType;
import kz.akkamal.tinysigner.entities.SignVerResult;
import kz.akkamal.tinysigner.entities.request.SignParameters;
import kz.akkamal.tinysigner.exception.ClientException;
import kz.akkamal.tinysigner.exception.SignatureVerifyingException;
import kz.akkamal.tinysigner.model.Model;
import kz.akkamal.tinysigner.service.CmsSignatureService;
import kz.akkamal.tinysigner.service.SignatureService;
import kz.akkamal.tinysigner.service.pdf.PdfSignatureService;
import kz.akkamal.tinysigner.utils.FileManageUtil;
import kz.akkamal.tinysigner.utils.Utils;
import kz.akkamal.tinysigner.view.SignersInfoFrame;
import kz.akkamal.tinysigner.view.StorageToViewTranslator;
import kz.akkamal.tinysigner.view.main.AbstractView;
import kz.akkamal.tinysigner.view.main.AuthView;
import kz.akkamal.tinysigner.view.main.DefaultView;
import kz.akkamal.tinysigner.view.main.ViewWithSignInfoBlock;
import kz.gov.pki.kalkan.Storage;
import kz.gov.pki.kalkan.util.encoders.Base64;
import kz.gov.pki.provider.exception.ProviderUtilException;
import kz.gov.pki.provider.exception.ProviderUtilExceptionCode;
import kz.gov.pki.provider.utils.KeyStoreUtil;
import kz.gov.pki.reference.KNCACertificateType;

public class Controller
implements Observer {
    private final Locale locale;
    private final String reqId;
    protected final SignParameters signParameters;
    private SignatureService signatureService;
    protected FileManager fileManager;
    protected CountDownLatch countDownLatch;
    protected AbstractView view;
    protected final Model model;

    public Controller(SignType signType, SignParameters signParameters, CountDownLatch readyLatch) {
        this.reqId = signParameters.getProcessId();
        this.signParameters = signParameters;
        this.countDownLatch = readyLatch;
        this.model = new Model();
        this.model.setCertType(signParameters.getCertType());
        this.model.setRequiredIin(signParameters.getIin());
        this.model.setRequiredBin(signParameters.getBin());
        this.model.setOids(signParameters.getOids());
        this.model.setDetached(signParameters.getSignMethod().equalsIgnoreCase("detached_cms"));
        this.locale = signParameters.getLocale() != null ? new Locale(signParameters.getLocale()) : new Locale("ru");
        Utils.locale = this.locale;
        try {
            switch (signType) {
                case SIGN_FILE_LOCAL: {
                    FileInfo fileInfo = this.askUserToChooseFile();
                    if (fileInfo == null) {
                        this.releaseLock();
                        return;
                    }
                    signParameters.setFileBase64(fileInfo.getSource());
                    signParameters.setFilename(fileInfo.getFilename());
                }
                case SIGN_FILE: {
                    this.fileManager = new Base64FileManager(signParameters.getFileBase64(), TinySigner.saveFileDirectory, signParameters.getFilename());
                    break;
                }
                case SIGN_FILE_URL: {
                    this.fileManager = new RemoteFileManager(signParameters.getUrl(), TinySigner.saveFileDirectory, signParameters.getFilename());
                    break;
                }
                case SIGN_JSON: {
                    this.fileManager = new JsonDataManager(signParameters.getAuthSignData(), TinySigner.saveFileDirectory, signParameters.getFilename());
                    break;
                }
                default: {
                    this.fileManager = null;
                    break;
                }
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.bindProcessResult(ErrorCode.MALFORMED_URL.getErrorCode(), e.getMessage());
            String errorMessage = Utils.getI18nMessage("malformed.url") + ": " + signParameters.getUrl();
            this.model.setMessage(errorMessage);
            this.view.showMessage(true);
            this.view.disposeView(false);
            return;
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.bindProcessResult(ErrorCode.GENERAL.getErrorCode(), e.getMessage());
            return;
        }
        if (signParameters.getSignMethod().equalsIgnoreCase("pdf") && signParameters.getFilename() != null && !signParameters.getFilename().toLowerCase().endsWith(".pdf")) {
            this.bindProcessResult(ErrorCode.INVALID_FILE_FORMAT.getErrorCode(), "incorrect file extension");
            this.releaseLock();
            return;
        }
        KNCACertificateType certificateType = null;
        try {
            if (this.isPdfOrCms(signParameters)) {
                this.view = new ViewWithSignInfoBlock(this);
                certificateType = KNCACertificateType.SIGNATURE;
            } else if (this.isForAuth(signParameters)) {
                this.view = new AuthView(this);
                certificateType = KNCACertificateType.AUTHENTICATION;
            } else {
                this.view = new DefaultView(this);
                certificateType = KNCACertificateType.SIGNATURE;
            }
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.bindProcessResult(ErrorCode.GENERAL.getErrorCode(), "create window error");
            this.releaseLock();
            return;
        }
        this.signatureService = signParameters.getSignMethod().equalsIgnoreCase("pdf") ? new PdfSignatureService(certificateType) : new CmsSignatureService(certificateType);
        if (this.fileManager != null) {
            this.fileManager.addObserver(this);
            this.fileManager.prepareFile();
        }
        this.updateContainersList();
    }

    private boolean isForAuth(SignParameters signParameters) {
        return signParameters.getSignMethod().equalsIgnoreCase("auth");
    }

    private boolean isPdfOrCms(SignParameters signParameters) {
        return signParameters.getFilename() != null && signParameters.getFilename().toLowerCase().contains(".cms") || signParameters.getSignMethod().equalsIgnoreCase("pdf");
    }

    private void settingFilePathAndVerifySignatures(String pathToSave, String fileName) {
        this.model.setSaveToPath(pathToSave);
        if (fileName.endsWith(".cms") || this.signParameters.getSignMethod().equalsIgnoreCase("pdf")) {
            try {
                if (fileName.endsWith(".cms")) {
                    Utils.extractContentFromSignature(pathToSave, this.model);
                }
                this.view.informAboutVerifyingProcess();
                this.signatureService.verify(this.model);
                List<AdditionalSignInfo> signVerResults = this.model.getSignVerResults();
                for (AdditionalSignInfo signVerResult : signVerResults) {
                    for (Object value : signVerResult.getOperationToResult().values()) {
                        if (!(value instanceof SignVerResult) || value != SignVerResult.FAILED) continue;
                        throw new SignatureVerifyingException(Utils.getI18nMessage("one.or.more.signatures.invalid"));
                    }
                }
            }
            catch (SignatureVerifyingException e) {
                BundleLog.LOG.error(e.getMessage(), e);
                this.model.setMessage(e.getMessage());
                this.model.setSignaturesInvalid(true);
                this.view.showMessage(true);
            }
            catch (Throwable e) {
                BundleLog.LOG.error(e.getMessage(), e);
                this.bindProcessResult(ErrorCode.INVALID_FILE_FORMAT.getErrorCode(), "error during file extracting");
                this.model.setMessage(Utils.getI18nMessage("extract.file.error"));
                this.view.showMessage(true);
                this.view.disposeView(false);
            }
        }
    }

    private FileInfo askUserToChooseFile() {
        FileInfo fileInfo = null;
        JFrame parent = new JFrame();
        try {
            int returnValue;
            parent.setLocationRelativeTo(null);
            parent.setDefaultCloseOperation(3);
            parent.setIconImage(new ImageIcon(Controller.class.getResource("/ts_small_logo_16px.png")).getImage());
            parent.pack();
            JFileChooser jfc = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
            jfc.setDialogTitle(Utils.getI18nMessage("file.choose.label"));
            if (this.signParameters.getSignMethod().equalsIgnoreCase("pdf")) {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("PDF", "pdf");
                jfc.setFileFilter(filter);
            }
            if ((returnValue = jfc.showOpenDialog(parent)) == 0) {
                File selectedFile = jfc.getSelectedFile();
                if (this.signParameters.getSignMethod().equalsIgnoreCase("pdf") && !selectedFile.getName().toLowerCase().endsWith(".pdf")) {
                    throw new IOException("incorrect file type. expected: pdf");
                }
                String fileBase64 = Base64.encodeStr((byte[])Files.readAllBytes(selectedFile.toPath()));
                fileBase64 = "base64," + fileBase64;
                fileInfo = new FileInfo(fileBase64, null, selectedFile.getName());
            } else {
                this.bindProcessResult(ErrorCode.USER_CANCELED.getErrorCode(), "module was closed");
            }
        }
        catch (IOException e) {
            BundleLog.LOG.error(e.getMessage(), e);
            this.bindProcessResult(ErrorCode.INVALID_FILE_FORMAT.getErrorCode(), e.getMessage());
        }
        parent.dispose();
        return fileInfo;
    }

    public void bindProcessResult(int errorCode, String errorMessage) {
        TinySigner.reqIdToProcessResult.put(this.reqId, new ProcessResult(errorCode, errorMessage));
    }

    public void releaseLock() {
        if (this.fileManager != null) {
            this.fileManager.cancel();
        }
        this.countDownLatch.countDown();
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public void update(Observable observable, Object o) {
        switch (this.fileManager.getFileInfo().getStatus()) {
            case IN_PROCESS: {
                if (this.model.getTotalSize() == 0) {
                    this.model.setTotalSize(this.fileManager.getFileInfo().getSize());
                    this.model.setFileName(this.fileManager.getFileInfo().getFilename());
                }
                this.model.setDownloaded(this.fileManager.getFileInfo().getProceed());
                this.view.updateFileInfo();
                break;
            }
            case COMPLETED: {
                this.settingFilePathAndVerifySignatures(this.fileManager.getFileInfo().getPathToSave(), this.fileManager.getFileInfo().getFilename());
                this.view.changeViewEnableState(true);
                this.view.setFileDownloaded(true);
                this.view.updateFileInfo();
                break;
            }
            case ERROR: {
                BundleLog.LOG.info("ERROR: " + this.fileManager.getFileInfo().getErrorMessage());
                this.bindProcessResult(this.fileManager.getFileInfo().getErrorCode(), this.fileManager.getFileInfo().getErrorMessage());
                this.model.setMessage(this.fileManager.getFileInfo().getErrorMessage());
                this.view.showMessage(true);
                this.view.disposeView(false);
            }
        }
    }

    public String getReqId() {
        return this.reqId;
    }

    public void upModuleWindow() {
        this.view.upModuleWindow();
        TinySigner.reqIdToProcessResult.put(this.reqId, new ProcessResult(ErrorCode.SUCCESS.getErrorCode(), "success"));
    }

    public void loadKeys() throws ClientException {
        try {
            KeyStorageInfo storageInfo = this.model.getKeyStorageInfo();
            KeyStore keyStore = this.getKeyStore(storageInfo);
            storageInfo.setKeyStore(keyStore);
            Map keyStoreEntries = KeyStoreUtil.getKeyStoreEntries((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (KNCACertificateType)this.signatureService.getSignType(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
            if (keyStoreEntries == null || keyStoreEntries.entrySet().isEmpty()) {
                BundleLog.LOG.info("[ERROR] no key in container. key storage type: " + storageInfo.getStorage());
                KNCACertificateType signType = this.signatureService.getSignType();
                if (signType == KNCACertificateType.SIGNATURE) {
                    throw new ClientException(Utils.getI18nMessage("no.key.in.container"));
                }
                throw new ClientException(Utils.getI18nMessage("no.auth.key.in.container"));
            }
            this.model.getKeyStorageInfo().setAvailableKeys(keyStoreEntries);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException(Utils.getI18nMessage("open.key.container.error"), e);
        }
    }

    private KeyStore getKeyStore(KeyStorageInfo storageInfo) throws ClientException {
        try {
            return KeyStoreUtil.getKeyStore((Storage)storageInfo.getStorage(), (String)storageInfo.getContainer(), (char[])storageInfo.getPassword(), (Provider)BundleProvider.KALKAN.getProvider());
        }
        catch (ProviderUtilException e) {
            BundleLog.LOG.log(1, e.getMessage(), e);
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.WRONG_KEYSTORE_PASSWORD)) {
                String msg = Utils.getI18nMessage("key.pass.invalid.error");
                if (e.getTryCount() > -1) {
                    msg = msg + " " + Utils.getI18nMessage("key.pass.invalid.try.amount") + " " + e.getTryCount();
                }
                throw new ClientException(msg);
            }
            if (e.getCode().equals((Object)ProviderUtilExceptionCode.BLOCKED_KEYSTORE_PASSWORD)) {
                throw new ClientException(Utils.getI18nMessage("key.pass.block.error"));
            }
            throw new ClientException(Utils.getI18nMessage("unknown.error"));
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new ClientException(Utils.getI18nMessage("unknown.error"), e);
        }
    }

    public void showSignersInfo() {
        SignersInfoFrame signersInfoFrame = new SignersInfoFrame(this, this.view, true);
        signersInfoFrame.setVisible(true);
    }

    public void updateContainersList() {
        SwingUtilities.invokeLater(() -> {
            this.model.setAvailableTokens(KeyStorageInfo.getAllAvailableStorageTypes().stream().map(StorageToViewTranslator::storageToView).collect(Collectors.toList()));
            this.view.updateContainersList();
            this.view.enableContainerListBox();
        });
    }

    public void loadLastSuccessKeyStorePath() {
        try {
            KeyPathsInfo.PathType pathType = this.signatureService.getSignType() == KNCACertificateType.AUTHENTICATION ? KeyPathsInfo.PathType.AUTH_KEY_PATH : KeyPathsInfo.PathType.SIGN_KEY_PATH;
            String p12KeyPath = KeyPathsInfo.getPath(pathType);
            this.model.setLastSuccessP12KeyFullPath(p12KeyPath);
            this.model.setLastSuccessP12KeyDirectory(p12KeyPath.substring(0, p12KeyPath.lastIndexOf(File.separator)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void signFile() {
        this.view.blockFullViewExcludeCancelBtn();
        SwingUtilities.invokeLater(() -> {
            try {
                Storage storage = this.model.getKeyStorageInfo().getStorage();
                if (storage == null) {
                    throw new ClientException(Utils.getI18nMessage("no.storage.type"));
                }
                if (this.model.getKeyStorageInfo().getContainer() == null) {
                    throw new ClientException(Utils.getI18nMessage("no.key.container"));
                }
                if (this.model.getKeyStorageInfo().getAlias() == null) {
                    throw new ClientException(Utils.getI18nMessage("no.key.alias"));
                }
                KeyStorageInfo storageInfo = this.model.getKeyStorageInfo();
                String alias = storageInfo.getAlias();
                this.signatureService.validateCertificate(storageInfo.getAvailableKeys().get(alias).getX509Certificate(), null, this.model);
                byte[] fileBytes = this.signatureService.getSignType() == KNCACertificateType.AUTHENTICATION ? this.fileManager.getFileInfo().getSource().getBytes("UTF-8") : (this.model.getCmsPath() != null ? FileManageUtil.readFileFrom(this.model.getCmsPath()) : FileManageUtil.readFileFrom(this.model.getSaveToPath()));
                byte[] signedData = this.signatureService.sign(this.model, fileBytes);
                String signInBase64 = Base64.encodeStr((byte[])signedData);
                TinySigner.reqIdToProcessResult.put(this.reqId, new ProcessResult(signInBase64));
                if (this.model.getKeyStorageInfo().getStorage() == Storage.PKCS12 && this.model.getLastSuccessP12KeyFullPath() != null && !this.model.getLastSuccessP12KeyFullPath().trim().isEmpty()) {
                    KeyPathsInfo.PathType pathType = this.signatureService.getSignType() == KNCACertificateType.AUTHENTICATION ? KeyPathsInfo.PathType.AUTH_KEY_PATH : KeyPathsInfo.PathType.SIGN_KEY_PATH;
                    KeyPathsInfo.updatePath(pathType, this.model.getLastSuccessP12KeyFullPath());
                }
                if (this.signatureService.getSignType() == KNCACertificateType.SIGNATURE) {
                    this.model.setMessage(Utils.getI18nMessage("file.signed.successful"));
                    this.view.showMessage(false);
                }
                this.view.disposeView(false);
            }
            catch (Exception e) {
                BundleLog.LOG.error("error during signing process", e);
                String errorMessage = this.signatureService.getSignType() == KNCACertificateType.AUTHENTICATION ? Utils.getI18nMessage("auth.process.error") : Utils.getI18nMessage("sign.process.error");
                this.model.setMessage(errorMessage + ": " + e.getMessage());
                this.view.showMessage(true);
                this.view.unblockFullView();
            }
        });
    }
}

