/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner;

import com.google.gson.Gson;
import java.util.Hashtable;
import kz.akkamal.tinysigner.TinySigner;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.common.BundleProvider;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.entities.RespObj;
import kz.akkamal.tinysigner.entities.request.DownloadProgressParameters;
import kz.akkamal.tinysigner.entities.request.SignParameters;
import kz.akkamal.tinysigner.exception.InvalidParametersException;
import kz.gov.pki.osgi.layer.api.ModuleService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TinySignerActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        try {
            BundleProvider.KALKAN.discoverProviderService();
            BundleLog.LOG.discoverLogService();
            this.registerService(bundleContext);
        }
        catch (Exception e) {
            BundleLog.LOG.error(e.getMessage(), e);
            throw new Exception("Can not start bundle TinySign!");
        }
    }

    private void registerService(BundleContext context) {
        TinySigner tinySigner = new TinySigner();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("module", "kz.akkamal.tinysigner");
        context.registerService(ModuleService.class.getName(), (jsonString, headers) -> {
            try {
                JSONObject jsonObject = new JSONObject(jsonString);
                String mname = jsonObject.getString("method");
                JSONArray args = jsonObject.optJSONArray("args");
                if (args == null) {
                    return this.getErrorResponse(null, "args parameter is not set", ErrorCode.INVALID_ARGS);
                }
                String parametersJson = (String)args.get(0);
                Gson gson = new Gson();
                switch (mname) {
                    case "signFileUrl": {
                        SignParameters signParameters = gson.fromJson(parametersJson, SignParameters.class);
                        if (TinySigner.inProcess) {
                            return this.getErrorResponse(signParameters.getProcessId(), "module already in process", ErrorCode.MODULE_IN_PROCESS);
                        }
                        return tinySigner.signFileUrl(signParameters);
                    }
                    case "signFile": {
                        SignParameters signParameters = gson.fromJson(parametersJson, SignParameters.class);
                        if (TinySigner.inProcess) {
                            return this.getErrorResponse(signParameters.getProcessId(), "module already in process", ErrorCode.MODULE_IN_PROCESS);
                        }
                        String fileBase64 = (String)args.get(1);
                        signParameters.setFileBase64(fileBase64);
                        return tinySigner.signFile(signParameters);
                    }
                    case "signFileLocal": {
                        SignParameters signParameters = gson.fromJson(parametersJson, SignParameters.class);
                        if (TinySigner.inProcess) {
                            return this.getErrorResponse(signParameters.getProcessId(), "module already in process", ErrorCode.MODULE_IN_PROCESS);
                        }
                        return tinySigner.signFileLocal(signParameters);
                    }
                    case "tsAuth": {
                        SignParameters signParameters = gson.fromJson(parametersJson, SignParameters.class);
                        String authDataToSign = (String)args.get(1);
                        signParameters.setAuthSignData(authDataToSign);
                        if (TinySigner.inProcess) {
                            return this.getErrorResponse(signParameters.getProcessId(), "module already in process", ErrorCode.MODULE_IN_PROCESS);
                        }
                        return tinySigner.signForAuth(signParameters);
                    }
                    case "downloadProgress": {
                        DownloadProgressParameters downloadProgressParameters = gson.fromJson(parametersJson, DownloadProgressParameters.class);
                        if (TinySigner.inProcess && TinySigner.reqIdToController.get(downloadProgressParameters.getProcessId()) == null) {
                            return this.getErrorResponse(downloadProgressParameters.getProcessId(), "module already in process", ErrorCode.MODULE_IN_PROCESS);
                        }
                        String fileBase64 = null;
                        if (args.length() > 1) {
                            fileBase64 = (String)args.get(1);
                        }
                        return tinySigner.downloadProgress(downloadProgressParameters, fileBase64);
                    }
                    case "upModuleWindow": {
                        if (!TinySigner.inProcess || TinySigner.reqIdToController.isEmpty()) {
                            return this.getErrorResponse(null, "no window to up", ErrorCode.MODULE_NOT_IN_PROCESS);
                        }
                        return tinySigner.upModuleWindow();
                    }
                }
                return this.getErrorResponse(null, "no such method: " + mname, ErrorCode.INVALID_MODULE_METHOD_NAME);
            }
            catch (InvalidParametersException e) {
                BundleLog.LOG.error(e.getMessage(), e);
                return this.getErrorResponse(null, e.getMessage(), ErrorCode.INVALID_ARGS);
            }
            catch (Exception e) {
                BundleLog.LOG.error(e.getMessage(), e);
                return this.getErrorResponse(null, e.getMessage(), ErrorCode.GENERAL);
            }
        }, props);
    }

    private String getErrorResponse(String reqId, String msg, ErrorCode errorCode) {
        TinySigner.inProcess = false;
        RespObj responseForJS = new RespObj(errorCode.getErrorCode());
        responseForJS.setErrorMessage(msg);
        responseForJS.setProcessId(reqId);
        return JSONObject.wrap(responseForJS).toString();
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

