/*
 * Decompiled with CFR 0.152.
 */
package kz.akkamal.tinysigner;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import kz.akkamal.tinysigner.common.BundleLog;
import kz.akkamal.tinysigner.controller.Controller;
import kz.akkamal.tinysigner.controller.ControllerWithDownloadProgressFunctional;
import kz.akkamal.tinysigner.entities.ErrorCode;
import kz.akkamal.tinysigner.entities.ProcessResult;
import kz.akkamal.tinysigner.entities.RespObj;
import kz.akkamal.tinysigner.entities.SignType;
import kz.akkamal.tinysigner.entities.request.DownloadProgressParameters;
import kz.akkamal.tinysigner.entities.request.SignParameters;
import kz.akkamal.tinysigner.exception.InvalidParametersException;
import kz.akkamal.tinysigner.model.Model;
import org.json.JSONObject;

public class TinySigner {
    private static final String GENERAL_ERROR = "error during signing process";
    public static volatile boolean inProcess = false;
    public static final String saveFileDirectory;
    public static Map<String, ProcessResult> reqIdToProcessResult;
    public static Map<String, Controller> reqIdToController;

    private static void createTempDirectory() {
        if (!new File(saveFileDirectory).exists()) {
            new File(saveFileDirectory).mkdirs();
            BundleLog.LOG.info("directory created: " + saveFileDirectory);
        }
    }

    private static void deleteFolderIgnoreErrors(File directory) {
        try {
            if (directory.exists()) {
                File[] files = directory.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (f.isDirectory()) {
                            TinySigner.deleteFolderIgnoreErrors(f);
                            continue;
                        }
                        f.delete();
                    }
                }
                directory.delete();
                BundleLog.LOG.info("temp directory cleaned successful: " + saveFileDirectory);
            }
        }
        catch (Exception ex) {
            BundleLog.LOG.error("Cant delete temp folder:" + ex.getMessage(), ex);
        }
    }

    protected synchronized String signFileUrl(SignParameters parameters) throws InvalidParametersException {
        if (!this.checkSignParameters(parameters, SignType.SIGN_FILE_URL)) {
            throw new InvalidParametersException("required parameters are not set");
        }
        TinySigner.createTempDirectory();
        inProcess = true;
        CountDownLatch readyLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(() -> reqIdToController.put(parameters.getProcessId(), new Controller(SignType.SIGN_FILE_URL, parameters, readyLatch)));
        try {
            readyLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RespObj<String> respObj = this.prepareResponse(parameters.getProcessId());
        TinySigner.resetAllData();
        return this.getJson(respObj);
    }

    protected synchronized String signFile(SignParameters parameters) throws InvalidParametersException {
        if (!this.checkSignParameters(parameters, SignType.SIGN_FILE)) {
            throw new InvalidParametersException("required parameters are not set");
        }
        TinySigner.createTempDirectory();
        inProcess = true;
        CountDownLatch readyLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(() -> reqIdToController.put(parameters.getProcessId(), new Controller(SignType.SIGN_FILE, parameters, readyLatch)));
        try {
            readyLatch.await();
        }
        catch (InterruptedException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        RespObj<String> respObj = this.prepareResponse(parameters.getProcessId());
        TinySigner.resetAllData();
        return this.getJson(respObj);
    }

    protected synchronized String signFileLocal(SignParameters parameters) throws InvalidParametersException {
        if (!this.checkSignParameters(parameters, SignType.SIGN_FILE_LOCAL)) {
            throw new InvalidParametersException("required parameters are not set");
        }
        TinySigner.createTempDirectory();
        inProcess = true;
        CountDownLatch readyLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(() -> reqIdToController.put(parameters.getProcessId(), new Controller(SignType.SIGN_FILE_LOCAL, parameters, readyLatch)));
        try {
            readyLatch.await();
        }
        catch (InterruptedException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        RespObj<String> respObj = this.prepareResponse(parameters.getProcessId());
        if (respObj.getErrorCode() == ErrorCode.SUCCESS.getErrorCode()) {
            JSONObject jsonObject = new JSONObject();
            Model model = reqIdToController.get(parameters.getProcessId()).getModel();
            jsonObject.put("filename", (Object)model.getFileName());
            jsonObject.put("signature", (Object)respObj.getData());
            respObj.setData(jsonObject.toString());
        }
        TinySigner.resetAllData();
        return this.getJson(respObj);
    }

    protected synchronized String signForAuth(SignParameters signParameters) throws InvalidParametersException {
        if (!this.checkSignParameters(signParameters, SignType.SIGN_JSON)) {
            throw new InvalidParametersException("required parameters are not set");
        }
        TinySigner.createTempDirectory();
        inProcess = true;
        CountDownLatch readyLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(() -> reqIdToController.put(signParameters.getProcessId(), new Controller(SignType.SIGN_JSON, signParameters, readyLatch)));
        try {
            readyLatch.await();
        }
        catch (InterruptedException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        RespObj<String> respObj = this.prepareResponse(signParameters.getProcessId());
        TinySigner.resetAllData();
        return this.getJson(respObj);
    }

    protected synchronized String downloadProgress(DownloadProgressParameters parameters, String fileBase64) throws InvalidParametersException {
        ControllerWithDownloadProgressFunctional controller;
        inProcess = true;
        if (!this.checkDownloadProcessParameters(parameters, fileBase64)) {
            throw new InvalidParametersException("error during parameters checking");
        }
        String operation = parameters.getOperation();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        SignParameters signParameters = new SignParameters();
        signParameters.setFilename(parameters.getFilename());
        signParameters.setProcessId(parameters.getProcessId());
        signParameters.setSignMethod(parameters.getSignMethod());
        signParameters.setBin(parameters.getBin());
        signParameters.setIin(parameters.getIin());
        signParameters.setLocale(parameters.getLocale());
        signParameters.setCertType(parameters.getCertType());
        signParameters.setOids(parameters.getOids());
        signParameters.setFileBase64(fileBase64);
        if (reqIdToController.get(signParameters.getProcessId()) == null) {
            controller = new ControllerWithDownloadProgressFunctional(signParameters, countDownLatch);
            reqIdToController.put(signParameters.getProcessId(), controller);
        } else {
            controller = (ControllerWithDownloadProgressFunctional)reqIdToController.get(signParameters.getProcessId());
            controller.setCountDownLatch(countDownLatch);
        }
        if (reqIdToProcessResult.get(parameters.getProcessId()) != null && reqIdToProcessResult.get(parameters.getProcessId()).getErrorCode() != ErrorCode.SUCCESS.getErrorCode()) {
            controller.setLastOperationResult(ControllerWithDownloadProgressFunctional.LastOperationResult.FAILED);
            RespObj<String> resp = this.prepareResponse(parameters.getProcessId());
            TinySigner.resetAllData();
            return this.getJson(resp);
        }
        if (controller.getLastOperationResult() == null || controller.getLastOperationResult() == ControllerWithDownloadProgressFunctional.LastOperationResult.OK) {
            if (operation.equalsIgnoreCase("update")) {
                SwingUtilities.invokeLater(() -> controller.updateDownloadInfo(parameters));
            } else if (operation.equalsIgnoreCase("sign")) {
                TinySigner.createTempDirectory();
                controller.setCountDownLatch(countDownLatch);
                SwingUtilities.invokeLater(() -> controller.startSignProcess(signParameters));
            }
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            BundleLog.LOG.error(e.getMessage(), e);
        }
        if (reqIdToProcessResult.get(parameters.getProcessId()) == null) {
            reqIdToProcessResult.put(parameters.getProcessId(), new ProcessResult(ErrorCode.SUCCESS.getErrorCode(), "ok"));
        }
        if (reqIdToProcessResult.get(parameters.getProcessId()).getErrorCode() != ErrorCode.SUCCESS.getErrorCode()) {
            controller.setLastOperationResult(ControllerWithDownloadProgressFunctional.LastOperationResult.FAILED);
        } else {
            controller.setLastOperationResult(ControllerWithDownloadProgressFunctional.LastOperationResult.OK);
        }
        RespObj<String> respObj = this.prepareResponse(parameters.getProcessId());
        if (parameters.getOperation().equalsIgnoreCase("sign")) {
            TinySigner.resetAllData();
        }
        return this.getJson(respObj);
    }

    public String upModuleWindow() throws InvalidParametersException {
        if (reqIdToController.size() > 1) {
            throw new InvalidParametersException("there is more than 1 controllers in process");
        }
        Controller currentController = reqIdToController.values().iterator().next();
        currentController.upModuleWindow();
        RespObj respObj = new RespObj();
        ProcessResult processResult = reqIdToProcessResult.get(currentController.getReqId());
        respObj.setProcessId(currentController.getReqId());
        if (processResult != null) {
            respObj.setErrorCode(processResult.getErrorCode());
            respObj.setErrorMessage(processResult.getErrorMessage());
        } else {
            respObj.setErrorCode(ErrorCode.GENERAL.getErrorCode());
            respObj.setErrorMessage("Error during up module window process");
        }
        reqIdToProcessResult.remove(currentController.getReqId());
        return this.getJson(respObj);
    }

    private RespObj<String> prepareResponse(String reqId) {
        RespObj<String> respObj = new RespObj<String>();
        if (reqIdToProcessResult.get(reqId) == null) {
            respObj.setProcessId(reqId);
            respObj.setErrorCode(ErrorCode.GENERAL.getErrorCode());
            respObj.setErrorMessage(GENERAL_ERROR);
        } else {
            respObj.setProcessId(reqId);
            if (reqIdToProcessResult.get(reqId).getErrorCode() != ErrorCode.SUCCESS.getErrorCode()) {
                respObj.setErrorCode(reqIdToProcessResult.get(reqId).getErrorCode());
                String message = reqIdToProcessResult.get(reqId).getErrorMessage();
                String errorMessage = message == null ? GENERAL_ERROR : message;
                respObj.setErrorMessage(errorMessage);
            } else {
                respObj.setErrorCode(ErrorCode.SUCCESS.getErrorCode());
                respObj.setData(reqIdToProcessResult.get(reqId).getSignInHex());
            }
        }
        TinySigner.deleteFolderIgnoreErrors(new File(saveFileDirectory));
        reqIdToProcessResult.remove(reqId);
        inProcess = false;
        return respObj;
    }

    private String getJson(Object o) {
        return JSONObject.wrap((Object)o).toString();
    }

    private boolean checkSignParameters(SignParameters signParameters, SignType signType) {
        if (signParameters.getProcessId() == null) {
            return false;
        }
        if (signParameters.getSignMethod() == null) {
            return false;
        }
        switch (signType) {
            case SIGN_FILE_URL: {
                if (signParameters.getUrl() == null) {
                    return false;
                }
                if (signParameters.getFilename() != null) break;
                return false;
            }
            case SIGN_FILE: {
                if (signParameters.getFilename() == null) {
                    return false;
                }
                if (signParameters.getFileBase64() != null) break;
                return false;
            }
            case SIGN_JSON: {
                if (signParameters.getAuthSignData() != null) break;
                return false;
            }
        }
        if (inProcess && reqIdToController.get(signParameters.getProcessId()) == null) {
            BundleLog.LOG.info("process id mismatch. expected: " + reqIdToController.get(signParameters.getProcessId()).getReqId() + " actual: " + signParameters.getProcessId());
            return false;
        }
        return true;
    }

    private boolean checkDownloadProcessParameters(DownloadProgressParameters parameters, String fileBase64) {
        if (parameters.getOperation() == null) {
            return false;
        }
        if (parameters.getProcessId() == null) {
            return false;
        }
        if (parameters.getFilename() == null) {
            return false;
        }
        if (parameters.getSignMethod() == null) {
            return false;
        }
        if (reqIdToController.get(parameters.getProcessId()) != null && ((ControllerWithDownloadProgressFunctional)reqIdToController.get(parameters.getProcessId())).getLastOperationResult() == ControllerWithDownloadProgressFunctional.LastOperationResult.FAILED) {
            return false;
        }
        return !parameters.getOperation().equalsIgnoreCase("pdf") || fileBase64 != null;
    }

    public static void resetAllData() {
        inProcess = false;
        reqIdToProcessResult.clear();
        reqIdToController.clear();
        BundleLog.LOG.info("all data reset");
    }

    static {
        String TEMP_DIR = System.getProperty("java.io.tmpdir").endsWith(File.separator) ? System.getProperty("java.io.tmpdir") : System.getProperty("java.io.tmpdir") + File.separator;
        saveFileDirectory = TEMP_DIR + "tinysign" + File.separator + "files";
        reqIdToProcessResult = new ConcurrentHashMap<String, ProcessResult>();
        reqIdToController = new ConcurrentHashMap<String, Controller>();
        TinySigner.deleteFolderIgnoreErrors(new File(saveFileDirectory));
    }
}

